<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\RoleUser;
use Illuminate\Support\Facades\Hash;
use DB;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         // Super Admin User
        User::create([
            'name' => 'Super Admin',
            'email' => 'superadmin@gmail.com',
            'password' => Hash::make('abcd1234'), // Always hash passwords!
			'created_at' => now(),
            'updated_at' => now(),
        ]);
		 DB::table('role_user')->insert([
            'user_id'    => 1,
            'role_id'    => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // Admin User
        User::create([
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('abcd1234'),
			'created_at' => now(),
            'updated_at' => now(),
        ]);
		 DB::table('role_user')->insert([
            'user_id'    => 2,
            'role_id'    => 2,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        // Admin User
        User::create([
            'name' => 'User',
            'email' => 'user@gmail.com',
            'password' => Hash::make('abcd1234'),
			'created_at' => now(),
            'updated_at' => now(),
        ]);
		 DB::table('role_user')->insert([
            'user_id'    => 3,
            'role_id'    => 3,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}