<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wardwise_election_results', function (Blueprint $table) {
            $table->id();
			$table->string('ward_en', 100)->unique(); // VARCHAR(255)           
			$table->string('ward_mr', 100)->nullable(); // VARCHAR(255)           
			$table->foreignId('general_election_id')->nullable();				
		    $table->softDeletes(); // Adds 'deleted_at' column for soft deletes
			$table->unsignedBigInteger('created_by')->nullable();
			$table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wardwise_election_results');
    }
};
