<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ward_compositions', function (Blueprint $table) {
            $table->id();
			$table->string('ward_en')->unique();
			$table->string('ward_mr')->nullable();
			$table->string('yearwise_population_en')->nullable();
			$table->string('yearwise_population_mr')->nullable();        
			$table->string('ward_major_places_en')->nullable();
			$table->string('ward_major_places_mr')->nullable();
			$table->string('current_reservation_en')->nullable();      
			$table->string('current_reservation_mr')->nullable();      
			$table->string('urlpath')->nullable();      
			$table->foreignId('general_election_id')->nullable();					
		    $table->softDeletes(); // Adds 'deleted_at' column for soft deletes
			$table->unsignedBigInteger('created_by')->nullable();
			$table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ward_compositions');
    }
};
