<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
	
	/* public function roles()
	{
		return $this->belongsToMany(RoleUser::class);
	} */
	public function roles()
	{
		return $this->belongsToMany(Role::class, 'role_user', 'user_id', 'role_id');
	}
	
	public function role()
	{
		return $this->belongsTo(RoleUser::class);
	}
	
	/* // user side relations
	
	//Assign roles to a user:
	$user = User::find(1);
	$user->roles()->attach([1, 2]); // Assign role IDs 1 and 2

	//Replace existing roles with new ones:
	$user->roles()->sync([2, 3]);

	//Remove a specific role:
	$user->roles()->detach(2);
	
	//Get all roles of a user:
	$roles = $user->roles; */

	public function hasRole($roleName)
	{
		return $this->roles()->where('role', $roleName)->exists();
	}
	
	/* if ($user->hasRole('admin')) {
    // allow access
	} */
	
	public function userRole(){
		return auth()->user()->roles->pluck('role')->toArray()[0];
	}
}
