<?php

namespace App\Http\Controllers;

use App\Models\WardwiseDocs;
use App\Models\ElectedCandidates;
use App\Models\PolingStationwiseVoterlist;
use App\Models\FinalVoterlist;
use App\Models\MuncipalCorporation;
use App\Models\WardwiseElectionResult;
use App\Models\NominationDocs;
use App\Models\NominationWard;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;

class WardwiseDocsController extends Controller
{
    /**
     * Display the specified resource.
     */
    public function show(ElectedCandidates $elected_candidate)
    {
		$wardwise_docs=$elected_candidate->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.show', compact('wardwise_docs','elected_candidate'));
    }
	
	public function pswvlShow(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
		$wardwise_docs=$poling_stationwise_voterlist->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.pswvl_show', compact('wardwise_docs','poling_stationwise_voterlist'));
    }	
	
	public function fvlShow(FinalVoterlist $final_voterlist)
    {
		$wardwise_docs=$final_voterlist->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.fvl_show', compact('wardwise_docs','final_voterlist'));
    }	
	
	public function mcShow(MuncipalCorporation $muncipal_corporation)
    {
		$wardwise_docs=$muncipal_corporation->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.mc_show', compact('wardwise_docs','muncipal_corporation'));
    }	
	public function ndShow(NominationWard $nomination_ward)
    {
		$wardwise_docs=$nomination_ward->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.nd_show', compact('wardwise_docs','nomination_ward'));
    }
	
	public function wwerShow(WardwiseElectionResult $wardwise_election_result)
    {
		$wardwise_docs=$wardwise_election_result->wardwise_docs;
		//$wardwise_docs=$elected_candidate->id;
		//echo "<pre>";print_r($wardwise_election_result->wardwise_docs);echo "</pre>";die();
        return view('wardwise_docs.wwer_show', compact('wardwise_docs','wardwise_election_result'));
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ElectedCandidates $wardwise_doc)
    {
		//echo "<pre>";print_r($elected_candidate);echo "</pre>";die();
        return view('wardwise_docs.edit', compact('wardwise_doc'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateElectedCandidatesRequest $request, ElectedCandidates $elected_candidate)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'elected_candidate_id' => $wardwise_docs->elected_candidate->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
				
        $elected_candidate->update($data);
		
        return redirect()->route('wardwise_docs.show',$wardwise_docs->elected_candidate);
    }

    /**
     * Remove the specified resource from storage.
     */
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WardwiseDocs $wardwise_doc)
    {
        $wardwise_doc->delete();
        return redirect()->route('wardwise_docs.show',$wardwise_doc->elected_candidate);
    }
}
