<?php

namespace App\Http\Controllers;

use App\Models\MainMenu;
use App\Models\SubMenu;
use Illuminate\Http\Request;
use App;

class SubMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(mainMenu $main_menu)
    {
		$currentLocale = App::getLocale();
        $sub_menus = SubMenu::all();
        return view('sub_menus.index', compact(['sub_menus','currentLocale']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('sub_menus.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(SoreSubMenuRequest  $request)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('image_en')) {
			$image_en = $request->file('image_en');

			// Optional: Custom filename
			$filename = time() . '_' . $image_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $image_en->storeAs('uploads', $filename, 'public');
		}
		
		$path_mr = null;

		if ($request->hasFile('image_mr')) {
			$image_mr = $request->file('image_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $image_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $image_mr->storeAs('uploads', $filename, 'public');
		}
		
		SubMenu::create([
			'title_en' => $data['title_en'],
			'title_mr' => $data['title_mr'],
			'headline_en' => $data['headline_en'],
			'headline_mr' => $data['headline_mr'],
			'image_en' => $path_en,
			'image_mr' => $path_mr,
		]);	
		
        return redirect()->route('sub_menus.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(SubMenu $mainMenu)
    {
        return view('sub_menus.edit', compact('main_menu'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SubMenu $main_menu)
    {
        return view('sub_menus.edit', compact('main_menu'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateSubMenuRequest $request, SubMenu $main_menu)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('image_en')) {
			$image_en = $request->file('image_en');

			// Optional: Custom filename
			$filename = time() . '_' . $image_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $image_en->storeAs('uploads', $filename, 'public');
			$data['image_en']=$path_en;
		}
		
		$path_mr = null;

		if ($request->hasFile('image_mr')) {
			$image_mr = $request->file('image_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $image_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $image_mr->storeAs('uploads', $filename, 'public');
			$data['image_mr']=$path_mr;
		}
		
		
		
		
		
        $main_menu->update($data);
		
        return redirect()->route('sub_menus.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SubMenu $main_menu)
    {
        $main_menu->delete();
        return redirect()->route('sub_menus.index');
    }
}
