<?php
namespace App\Http\Controllers;

use App\Http\Requests\StoreNominationWardRequest;
use App\Http\Requests\UpdateNominationWardRequest;
use App\Models\NominationDocs;
use App\Models\NominationWard;
use App\Models\WardwiseDocs;
use Illuminate\Http\Request;
use App;

class NominationWardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(NominationDocs $nomination_doc)
    {
		$currentLocale = App::getLocale();
        $nomination_wards =$nomination_doc->nomination_wards;// NominationWard::all();
		//echo "<pre>";print_r($nomination_doc->id);echo "</pre>";die();
        return view('nomination_wards.index', compact(['nomination_wards','currentLocale','nomination_doc']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(NominationDocs $nomination_doc)
    {
		$currentLocale = App::getLocale();
		//echo "<pre>";print_r($nomination_doc);echo "</pre>";die();
        return view('nomination_wards.create', compact(['currentLocale','nomination_doc']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNominationWardRequest  $request,NominationDocs $nomination_doc)
    {
		
        $data = $request->validated();
        
		$currentLocale = App::getLocale();		
		//	echo "<pre>";print_r($data);echo "</pre>";die();
		$nomination_ward=NominationWard::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'nomination_doc_id' =>$nomination_doc->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'nomination_ward_id' => $nomination_ward->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
		
        return redirect()->route('nomination_wards.index',$nomination_doc);
    }

    /**
     * Display the specified resource.
     */
    public function show(NominationWard $nomination_ward)
    {
        return view('nomination_wards.edit', compact('nomination_ward'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NominationWard $nomination_ward)
    {
		//echo "<pre>";print_r($nomination_ward);echo "</pre>";die();
        return view('nomination_wards.edit', compact('nomination_ward'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateNominationWardRequest $request, NominationWard $nomination_ward)
    {
        $data = $request->validated();		 
				
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'nomination_ward_id' => $nomination_ward->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}		
		
        $nomination_ward->update($data);
		
        return redirect()->route('nomination_wards.index',$nomination_ward->nomination_doc);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NominationWard $nomination_ward)
    {
        $nomination_ward->delete();
        return redirect()->route('nomination_wards.index',$nomination_ward->nomination_doc);
    }
}
