<?php

namespace App\Http\Controllers;

use App\Models\MainMenu;
use Illuminate\Http\Request;
use App\Http\Requests\SoreMainMenuRequest;
use App\Http\Requests\UpdateMainMenuRequest;
use App;

class MainMenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
		$currentLocale = App::getLocale();
        $main_menus = MainMenu::all();
        return view('main_menus.index', compact(['main_menus','currentLocale']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('main_menus.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(SoreMainMenuRequest  $request)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('image_en')) {
			$image_en = $request->file('image_en');

			// Optional: Custom filename
			$filename = time() . '_' . $image_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $image_en->storeAs('uploads', $filename, 'public');
		}
		
		$path_mr = null;

		if ($request->hasFile('image_mr')) {
			$image_mr = $request->file('image_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $image_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $image_mr->storeAs('uploads', $filename, 'public');
		}
		
		MainMenu::create([
			'title_en' => $data['title_en'],
			'title_mr' => $data['title_mr'],
			'headline_en' => $data['headline_en'],
			'headline_mr' => $data['headline_mr'],
			'image_en' => $path_en,
			'image_mr' => $path_mr,
		]);	
		
        return redirect()->route('main_menus.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(MainMenu $mainMenu)
    {
        return view('main_menus.edit', compact('main_menu'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MainMenu $main_menu)
    {
        return view('main_menus.edit', compact('main_menu'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMainMenuRequest $request, MainMenu $main_menu)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('image_en')) {
			$image_en = $request->file('image_en');

			// Optional: Custom filename
			$filename = time() . '_' . $image_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $image_en->storeAs('uploads', $filename, 'public');
			$data['image_en']=$path_en;
		}
		
		$path_mr = null;

		if ($request->hasFile('image_mr')) {
			$image_mr = $request->file('image_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $image_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $image_mr->storeAs('uploads', $filename, 'public');
			$data['image_mr']=$path_mr;
		}
		
		
		
		
		
        $main_menu->update($data);
		
        return redirect()->route('main_menus.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MainMenu $main_menu)
    {
        $main_menu->delete();
        return redirect()->route('main_menus.index');
    }
}
