<?php
namespace App\Http\Controllers;

use App\Http\Requests\StoreFinalVoterlistRequest;
use App\Http\Requests\UpdateFinalVoterlistRequest;
use App\Models\FinalVoterlist;
use App\Models\WardwiseDocs;
use Illuminate\Http\Request;
use App\Models\GeneralElection;
use App;
use Auth;

class FinalVoterlistController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $final_voterlists = $general_election->final_voterlists;//FinalVoterlist::all();
        return view('final_voterlists.index', compact(['final_voterlists','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('final_voterlists.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreFinalVoterlistRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$final_voterlist=FinalVoterlist::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'general_election_id' =>$general_election->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'final_voterlist_id' => $final_voterlist->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
		
		
        return redirect()->route('final_voterlists.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(FinalVoterlist $final_voterlist)
    {
        return view('final_voterlists.edit', compact('final_voterlist'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(FinalVoterlist $final_voterlist)
    {
		//echo "<pre>";print_r($final_voterlist);echo "</pre>";die();
        return view('final_voterlists.edit', compact('final_voterlist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateFinalVoterlistRequest $request, FinalVoterlist $final_voterlist)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'final_voterlist_id' => $final_voterlist->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}
		
		
        $final_voterlist->update($data);
		
        return redirect()->route('final_voterlists.index',$final_voterlist->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FinalVoterlist $final_voterlist)
    {
        $final_voterlist->delete();
        return redirect()->route('final_voterlists.index',$final_voterlist->general_election);
    }
}
