<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreConfigsRequest;
use App\Http\Requests\UpdateConfigsRequest;
use App\Models\Configs;
use Illuminate\Http\Request;
use App;

class ConfigsController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
		$currentLocale = App::getLocale();
        $configs = Configs::all();
        return view('configs.index', compact(['configs','currentLocale']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('configs.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreConfigsRequest  $request)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$banner_path = null;

		if ($request->hasFile('banner')) {
			$banner = $request->file('banner');

			// Optional: Custom filename
			$filename = time() . '_' . $banner->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$banner_path = $banner->storeAs('uploads', $filename, 'public');
		}
						
		$config=Configs::create([
			'content_en' => $data['content_en'],
			'content_mr' => $data['content_mr'],			
			'banner' => $banner_path,		
		]);	
		
        return redirect()->route('configs.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Configs $mainMenu)
    {
        return view('configs.edit', compact('config'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Configs $config)
    {
        return view('configs.edit', compact('config'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateConfigsRequest $request, Configs $config)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$banner = null;

		if ($request->hasFile('banner')) {
			$banner = $request->file('banner');

			// Optional: Custom filename
			$filename = time() . '_' . $banner->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$banner = $banner->storeAs('uploads', $filename, 'public');
			$data['banner']=$banner;
		}
		
	
		
		
		
		
		
        $config->update($data);
		
        return redirect()->route('configs.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Configs $config)
    {
        $config->delete();
        return redirect()->route('configs.index');
    }
}
