<?php
namespace App\Helpers;

use Auth;
use App\Models\Option;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Topic;
use App\Models\Section;
use App\Models\Color;

class OptionsHelper
{
	public static function options($name, $empty = '') {
		return ['' => $empty] + Option::where('name', $name)->pluck('value', 'value')->toArray();
	}
	
	public static function appOptions($name, $empty = '') {
		if (!$empty) {
			return require(app_path("Options/{$name}.php"));			
		} else {
			return ['' => $empty] + require(app_path("Options/{$name}.php"));
		}
	}
	
	public static function colorOptions() {
		return ['' => ''] + Color::pluck('name', 'id')->toArray();
	}
	
	public static function roles($role) {
		$options = [];
		$roles = ($role=="Super Admin")?(self::appOptions('Roles')) : (self::appOptions('sRoles'));
		foreach ($roles as $k => $v) {
			$options[$k] = $k;
		}
		return $options;
	}
	


	
	
	
}
