<?php

use Illuminate\Support\Facades\Route;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ElectedCandidatesController;
use App\Http\Controllers\MuncipalCorporationController;
use App\Http\Controllers\NominationDocsController;
use App\Http\Controllers\GeneralElectionController;
use App\Http\Controllers\NagpurMuncipalelectionController;
use App\Http\Controllers\PolingStationwiseVoterlistController;
use App\Http\Controllers\FinalVoterlistController;
use App\Http\Controllers\WardwiseElectionResultController;
use App\Http\Controllers\PublicController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

/* Route::get('/', function () {
    return view('welcome');
}); */

	Route::get('/', [PublicController::class, 'welcome'])->name('welcome');
	Route::get('/about', [PublicController::class, 'about'])->name('about');
	Route::get('/election_view/{general_election}', [PublicController::class, 'electionView'])->name('election_view');
	Route::get('/elected_candidates', [PublicController::class, 'electedCandidates'])->name('elected_candidates');
	Route::get('/ward_composition', [PublicController::class, 'wardComposition'])->name('ward_composition');

	Auth::routes();


Route::middleware(['auth'])->prefix('superadmin')->group(function () {
	Route::get('/home', [HomeController::class, 'index'])->name('superadmins.home');
   
	// Users
	Route::get('/users/index', [UserController::class, 'index'])->name('users.index');
	Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
	Route::post('/users/store', [UserController::class, 'store'])->name('users.store');
	Route::get('/users/edit/{role}', [UserController::class, 'edit'])->name('users.edit');
	Route::post('/users/update/{role}', [UserController::class, 'update'])->name('users.update');
	Route::post('/users/destroy/{role}', [UserController::class, 'destroy'])->name('users.destroy');

	// Roles
	Route::get('/roles/index', [RoleController::class, 'index'])->name('roles.index');
	Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
	Route::post('/roles/store', [RoleController::class, 'store'])->name('roles.store');
	Route::get('/roles/edit/{role}', [RoleController::class, 'edit'])->name('roles.edit');
	Route::post('/roles/update/{role}', [RoleController::class, 'update'])->name('roles.update');
	Route::post('/roles/destroy/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');

	// Elected Candidates   
	Route::get('/elected_candidates/index/{general_election}', [ElectedCandidatesController::class, 'index'])->name('elected_candidates.index');
	Route::get('/elected_candidates/create/{general_election}', [ElectedCandidatesController::class, 'create'])->name('elected_candidates.create');
	Route::post('/elected_candidates/store/{general_election}', [ElectedCandidatesController::class, 'store'])->name('elected_candidates.store');
	Route::get('/elected_candidates/edit/{elected_candidate}', [ElectedCandidatesController::class, 'edit'])->name('elected_candidates.edit');
	Route::post('/elected_candidates/update/{elected_candidate}', [ElectedCandidatesController::class, 'update'])->name('elected_candidates.update');
	Route::post('/elected_candidates/destroy/{elected_candidate}', [ElectedCandidatesController::class, 'destroy'])->name('elected_candidates.destroy');

	// Polling station wise voter list   
	Route::get('/poling_stationwise_voterlists/index/{general_election}', [PolingStationwiseVoterlistController::class, 'index'])->name('poling_stationwise_voterlists.index');
	Route::get('/poling_stationwise_voterlists/create/{general_election}', [PolingStationwiseVoterlistController::class, 'create'])->name('poling_stationwise_voterlists.create');
	Route::post('/poling_stationwise_voterlists/store/{general_election}', [PolingStationwiseVoterlistController::class, 'store'])->name('poling_stationwise_voterlists.store');
	Route::get('/poling_stationwise_voterlists/edit/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'edit'])->name('poling_stationwise_voterlists.edit');
	Route::post('/poling_stationwise_voterlists/update/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'update'])->name('poling_stationwise_voterlists.update');
	Route::post('/poling_stationwise_voterlists/destroy/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'destroy'])->name('poling_stationwise_voterlists.destroy');

	// Final voter list   
	Route::get('/final_voterlists/index/{general_election}', [FinalVoterlistController::class, 'index'])->name('final_voterlists.index');
	Route::get('/final_voterlists/create/{general_election}', [FinalVoterlistController::class, 'create'])->name('final_voterlists.create');
	Route::post('/final_voterlists/store/{general_election}', [FinalVoterlistController::class, 'store'])->name('final_voterlists.store');
	Route::get('/final_voterlists/edit/{final_voterlist}', [FinalVoterlistController::class, 'edit'])->name('final_voterlists.edit');
	Route::post('/final_voterlists/update/{final_voterlist}', [FinalVoterlistController::class, 'update'])->name('final_voterlists.update');
	Route::post('/final_voterlists/destroy/{final_voterlist}', [FinalVoterlistController::class, 'destroy'])->name('final_voterlists.destroy');

	// Wardwise Election Result  
	Route::get('/wardwise_election_results/index/{general_election}', [WardwiseElectionResultController::class, 'index'])->name('wardwise_election_results.index');
	Route::get('/wardwise_election_results/create/{general_election}', [WardwiseElectionResultController::class, 'create'])->name('wardwise_election_results.create');
	Route::post('/wardwise_election_results/store/{general_election}', [WardwiseElectionResultController::class, 'store'])->name('wardwise_election_results.store');
	Route::get('/wardwise_election_results/edit/{wardwise_election_result}', [WardwiseElectionResultController::class, 'edit'])->name('wardwise_election_results.edit');
	Route::post('/wardwise_election_results/update/{wardwise_election_result}', [WardwiseElectionResultController::class, 'update'])->name('wardwise_election_results.update');
	Route::post('/wardwise_election_results/destroy/{wardwise_election_result}', [WardwiseElectionResultController::class, 'destroy'])->name('wardwise_election_results.destroy');

	// Muncipal Corporations
	Route::get('/muncipal_corporations/index/{general_election}', [MuncipalCorporationController::class, 'index'])->name('muncipal_corporations.index');
	Route::get('/muncipal_corporations/create/{general_election}', [MuncipalCorporationController::class, 'create'])->name('muncipal_corporations.create');
	Route::post('/muncipal_corporations/store/{general_election}', [MuncipalCorporationController::class, 'store'])->name('muncipal_corporations.store');
	Route::get('/muncipal_corporations/edit/{muncipal_corporation}', [MuncipalCorporationController::class, 'edit'])->name('muncipal_corporations.edit');
	Route::post('/muncipal_corporations/update/{muncipal_corporation}', [MuncipalCorporationController::class, 'update'])->name('muncipal_corporations.update');
	Route::post('/muncipal_corporations/destroy/{muncipal_corporation}', [MuncipalCorporationController::class, 'destroy'])->name('muncipal_corporations.destroy');

	// Nomination Docs
	Route::get('/nomination_docs/index/{general_election}', [NominationDocsController::class, 'index'])->name('nomination_docs.index');
	Route::get('/nomination_docs/create/{general_election}', [NominationDocsController::class, 'create'])->name('nomination_docs.create');
	Route::post('/nomination_docs/store/{general_election}', [NominationDocsController::class, 'store'])->name('nomination_docs.store');
	Route::get('/nomination_docs/edit/{nomination_doc}', [NominationDocsController::class, 'edit'])->name('nomination_docs.edit');
	Route::post('/nomination_docs/update/{nomination_doc}', [NominationDocsController::class, 'update'])->name('nomination_docs.update');
	Route::post('/nomination_docs/destroy/{nomination_doc}', [NominationDocsController::class, 'destroy'])->name('nomination_docs.destroy');

	// General Elections
	Route::get('/general_elections/index', [GeneralElectionController::class, 'index'])->name('general_elections.index');
	Route::get('/general_elections/create', [GeneralElectionController::class, 'create'])->name('general_elections.create');
	Route::post('/general_elections/store', [GeneralElectionController::class, 'store'])->name('general_elections.store');
	Route::get('/general_elections/edit/{general_election}', [GeneralElectionController::class, 'edit'])->name('general_elections.edit');
	Route::post('/general_elections/update/{general_election}', [GeneralElectionController::class, 'update'])->name('general_elections.update');
	Route::post('/general_elections/destroy/{general_election}', [GeneralElectionController::class, 'destroy'])->name('general_elections.destroy');

	// General Elections
	Route::get('/nagpur_muncipalelections/show/{general_election}', [NagpurMuncipalelectionController::class, 'show'])->name('nagpur_muncipalelections.show');


   
    // Add more admin routes here
});
Route::middleware(['auth'])->prefix('admin')->group(function () {
   Route::get('/adminhome', [HomeController::class, 'adminIndex'])->name('admins.adminhome');
    // Add more admin routes here
}); 
Route::middleware(['auth'])->prefix('user')->group(function () {
   Route::get('/userhome', [HomeController::class, 'userIndex'])->name('users.userhome');
    // Add more admin routes here
}); 



Route::get('lang/{locale}', function ($locale) {
    if (!in_array($locale, ['en', 'mr'])) {
        abort(400);
    }

    App::setLocale($locale);
    Session::put('locale', $locale);

    return redirect()->back();
});