@extends('layouts.app')
@section('content')

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							Edit Nomination Documents
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('nomination_docs.index',$nomination_doc->general_election) }}">Back</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<form method="POST" action="{{route('nomination_docs.update',$nomination_doc) }}" file="true" enctype="multipart/form-data">
						@csrf
						<div class="p-3">
							<div class="mb-3">
							  <label for="returning_officer_en" class="form-label">{{__('labels.title_en')}}</label>
							  <input type="text" class="form-control" id="returning_officer_en" name="returning_officer_en" value="{{old('returning_officer_en',$nomination_doc->returning_officer_en)}}" placeholder="enter returning officer ">
							</div>
							
							<div class="mb-3">
							  <label for="returning_officer_mr" class="form-label">{{__('labels.title_mr')}}</label>
							  <input type="text" class="form-control" id="returning_officer_mr" name="returning_officer_mr" value="{{old('returning_officer_mr',$nomination_doc->returning_officer_mr)}}" placeholder="enter returning officer marathi">
							</div>	
							
							<div class="mb-3">
							  <label for="file_en" class="form-label">{{__('labels.file_en')}}</label>
							  <input type="file" class="form-control" id="file_en" name="file_en" accept="image/*" placeholder="enter english image">
							</div>					
							
							<div class="mb-3">
							  <label for="file_mr" class="form-label">{{__('labels.file_mr')}}</label>
							  <input type="file" class="form-control" id="file_mr" name="file_mr" accept="image/*" placeholder="enter marathi image">
							</div>					
							
							<div class="py-3 text-center">
							 
							<button class="btn btn-success  btn-sm mb-1" type="submit">Update</button>

							</div>

						
						</div>
					</form>				
                </div>
            </div>
        </div>
    </div>
</div>


@endsection