@extends('layouts.app')
@section('content')

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							Edit muncipal_corporations
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('muncipal_corporations.index',$muncipal_corporation->general_election) }}">Back</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<form method="POST" action="{{route('muncipal_corporations.update',$muncipal_corporation) }}" file="true" enctype="multipart/form-data">
						@csrf
						<div class="p-3">
							<div class="mb-3">
							  <label for="title_en" class="form-label">{{__('labels.title_en')}}</label>
							  <input type="text" class="form-control" id="title_en" name="title_en" value="{{old('title_en',$muncipal_corporation->title_en)}}" placeholder="enter ward in english">
								 							</div>
							<div class="mb-3">
							  <label for="title_mr" class="form-label">{{__('labels.title_mr')}}</label>
							  <input type="text" class="form-control" id="title_mr" name="title_mr" value="{{old('title_mr',$muncipal_corporation->title_mr)}}" placeholder="enter ward in marathi">
							</div>
							
							<div class="mb-3">
							  <label for="file_en" class="form-label">{{__('labels.file_en')}}</label>
							  <input type="file" class="form-control" id="file_en" name="file_en" accept="image/*,application/pdf" placeholder="enter english image">
							</div>					
							
							<div class="mb-3">
							  <label for="file_mr" class="form-label">{{__('labels.file_mr')}}</label>
							  <input type="file" class="form-control" id="file_mr" name="file_mr" accept="image/*,application/pdf" placeholder="enter marathi image">
							</div>					
							
							<div class="py-3 text-center">
							 
							<button class="btn btn-success  btn-sm mb-1" type="submit">Update</button>

							</div>

						
						</div>
					</form>				
                </div>
            </div>
        </div>
    </div>
</div>


@endsection