<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nomination_docs', function (Blueprint $table) {
            $table->id();
			$table->string('returning_officer_en'); // VARCHAR(255)           
			$table->string('returning_officer_mr')->nullable(); // VARCHAR(255)           
			$table->string('file_en')->nullable(); // VARCHAR(255) 		 
			$table->string('file_mr')->nullable(); // VARCHAR(255)
			$table->string('file_ext_en')->nullable(); // VARCHAR(255) 		 
			$table->string('file_ext_mr')->nullable(); // VARCHAR(255) 					
			$table->foreignId('general_election_id')->nullable();					
		    $table->softDeletes(); // Adds 'deleted_at' column for soft deletes
			$table->unsignedBigInteger('created_by')->nullable();
			$table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nomination_docs');
    }
};
