<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;

class BaseModel extends Model
{
    // Common properties or methods for all models
	use HasFactory;
    // Example: disable timestamps for all models by default
    public $timestamps = false;

    // Example: mass assign all by default
    protected $guarded = [];

    // Example: common method
    public function getCreatedAtFormatted()
    {
        return $this->created_at ? $this->created_at->format('d-m-Y') : null;
    }
	
	protected static function booted()
    {
        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = Auth::id();
                $model->updated_by = Auth::id();
            }
        });

        static::updating(function ($model) {
            if (Auth::check()) {
                $model->updated_by = Auth::id();
            }
        });
    }
}
