<?php
namespace App\Http\Controllers;

use App\Http\Requests\StoreWardwiseElectionResultRequest;
use App\Http\Requests\UpdateWardwiseElectionResultRequest;
use App\Models\WardwiseElectionResult;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;

class WardwiseElectionResultController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $wardwise_election_results = WardwiseElectionResult::all();
        return view('wardwise_election_results.index', compact(['wardwise_election_results','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('wardwise_election_results.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreWardwiseElectionResultRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		WardwiseElectionResult::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' =>$general_election->id
		]);	
		
        return redirect()->route('wardwise_election_results.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(WardwiseElectionResult $wardwise_election_result)
    {
        return view('wardwise_election_results.edit', compact('wardwise_election_result'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(WardwiseElectionResult $wardwise_election_result)
    {
		//echo "<pre>";print_r($wardwise_election_result);echo "</pre>";die();
        return view('wardwise_election_results.edit', compact('wardwise_election_result'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateWardwiseElectionResultRequest $request, WardwiseElectionResult $wardwise_election_result)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);		
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');	

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']= pathinfo($path_mr, PATHINFO_EXTENSION);
		}
		
        $wardwise_election_result->update($data);
		
        return redirect()->route('wardwise_election_results.index',$wardwise_election_result->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WardwiseElectionResult $wardwise_election_result)
    {
        $wardwise_election_result->delete();
        return redirect()->route('wardwise_election_results.index',$wardwise_election_result->general_election);
    }
}
