<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePolingStationwiseVoterlistRequest;
use App\Http\Requests\UpdatePolingStationwiseVoterlistRequest;
use App\Models\PolingStationwiseVoterlist;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;

class PolingStationwiseVoterlistController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $poling_stationwise_voterlists = PolingStationwiseVoterlist::all();
        return view('poling_stationwise_voterlists.index', compact(['poling_stationwise_voterlists','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('poling_stationwise_voterlists.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePolingStationwiseVoterlistRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		PolingStationwiseVoterlist::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' =>$general_election->id
		]);	
		
        return redirect()->route('poling_stationwise_voterlists.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        return view('poling_stationwise_voterlists.edit', compact('poling_stationwise_voterlist'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
		//echo "<pre>";print_r($poling_stationwise_voterlist);echo "</pre>";die();
        return view('poling_stationwise_voterlists.edit', compact('poling_stationwise_voterlist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePolingStationwiseVoterlistRequest $request, PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);		
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');	

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']= pathinfo($path_mr, PATHINFO_EXTENSION);
		}
				
        $poling_stationwise_voterlist->update($data);
		
        return redirect()->route('poling_stationwise_voterlists.index',$poling_stationwise_voterlist->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        $poling_stationwise_voterlist->delete();
        return redirect()->route('poling_stationwise_voterlists.index',$poling_stationwise_voterlist->general_election);
    }
}
