<?php
namespace App\Http\Controllers;

use App\Http\Requests\StoreFinalVoterlistRequest;
use App\Http\Requests\UpdateFinalVoterlistRequest;
use App\Models\FinalVoterlist;
use Illuminate\Http\Request;
use App\Models\GeneralElection;
use App;
use Auth;

class FinalVoterlistController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $final_voterlists = FinalVoterlist::all();
        return view('final_voterlists.index', compact(['final_voterlists','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('final_voterlists.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreFinalVoterlistRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		FinalVoterlist::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' =>$general_election->id
		]);	
		
        return redirect()->route('final_voterlists.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(FinalVoterlist $final_voterlist)
    {
        return view('final_voterlists.edit', compact('final_voterlist'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(FinalVoterlist $final_voterlist)
    {
		//echo "<pre>";print_r($final_voterlist);echo "</pre>";die();
        return view('final_voterlists.edit', compact('final_voterlist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateFinalVoterlistRequest $request, FinalVoterlist $final_voterlist)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);		
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');	

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']= pathinfo($path_mr, PATHINFO_EXTENSION);
		}
		
		
		
		
		
        $final_voterlist->update($data);
		
        return redirect()->route('final_voterlists.index',$final_voterlist->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FinalVoterlist $final_voterlist)
    {
        $final_voterlist->delete();
        return redirect()->route('final_voterlists.index',$final_voterlist->general_election);
    }
}
