<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreElectedCandidatesRequest;
use App\Http\Requests\UpdateElectedCandidatesRequest;
use App\Models\ElectedCandidates;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;
use Auth;

class ElectedCandidatesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $elected_candidates = ElectedCandidates::all();
        return view('elected_candidates.index', compact(['elected_candidates','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('elected_candidates.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreElectedCandidatesRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		ElectedCandidates::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' =>$general_election->id
		]);	
		
        return redirect()->route('elected_candidates.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(ElectedCandidates $elected_candidate)
    {
        return view('elected_candidates.edit', compact('elected_candidate'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ElectedCandidates $elected_candidate)
    {
		//echo "<pre>";print_r($elected_candidate);echo "</pre>";die();
        return view('elected_candidates.edit', compact('elected_candidate'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateElectedCandidatesRequest $request, ElectedCandidates $elected_candidate)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);		
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');	

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']= pathinfo($path_mr, PATHINFO_EXTENSION);
		}
		
		
		
		
		
        $elected_candidate->update($data);
		
        return redirect()->route('elected_candidates.index',$elected_candidate->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ElectedCandidates $elected_candidate)
    {
        $elected_candidate->delete();
        return redirect()->route('elected_candidates.index',$elected_candidate->general_election);
    }
}
