<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function showLoginForm()
    {
        return view('auth.login'); // your login view
    } 

    public function login(Request $request)
    {
		
        // Validate the incoming request
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        // Attempt to log the user in
        if (Auth::attempt($credentials, $request->filled('remember'))) {
            
			$request->session()->regenerate();

            $user = Auth::user();
			
			$userRolesArray=array_values($user->roles->pluck('role')->toArray());
			
			//echo "<pre>";print_r(!in_array($userRolesArray,['superadmin']));echo "</pre>";die();

            // Redirect based on role
            if (in_array('superadmin',$userRolesArray)) {
                return redirect()->intended('/superadmin/home');
            } elseif (in_array('admin',$userRolesArray)) {
                return redirect()->intended('/admin/adminhome');
            } else {
                return redirect()->intended('user/userhome');
            }
        }

        // Authentication failed
        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ])->onlyInput('email');
		
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/login');
    }
}
