@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
 
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
			 <nav aria-label="breadcrumb">
			  <ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{route('general_elections.index')}}">General Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nagpur_muncipalelections.show',$nomination_doc->general_election)}}">Nagpur Muncipal Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nomination_docs.index',$nomination_doc->general_election)}}">Nomination Officers</a></li>
				<li class="breadcrumb-item active" aria-current="page">Nomination Wards</li>
			  </ol>
			</nav>
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Nomination Wards List') }} of {{$nomination_doc->returning_officer_en}}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('nomination_wards.create',$nomination_doc) }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body p-5">				
				
					<div class="row">
						@foreach ($nomination_wards as $nomination_ward)
							<div class="col-sm-2 mb-3 mb-sm-0">
								<div class="card text-center">
								  <div class="card-body">
								  
									<div class="opacity-100">
										<a style="text-decoration:none;font-size:18px;font-weight:bold;" href="{{route('wardwise_docs.nd_show',$nomination_ward)}}">
											@if($currentLocale=='en')
												{{ $nomination_ward->ward_en }}
											@else
												{{ $nomination_ward->ward_mr }}	
											@endif
										</a>

										<div class="d-flex justify-content-end align-items-center" >
											<div>
												<a href="{{ route('nomination_wards.edit',$nomination_ward) }}"><i class="fa-regular fa-edit"></i></a> 
											</div>				
											<div>				
												<form action="{{ route('nomination_wards.destroy', $nomination_ward) }}" method="POST" style="display:inline;">
													@csrf
													<!-- @method('DELETE') -->
													<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
												</form>
											</div>
										</div>
									</div>	  
									
								  </div>
								</div>
							</div>  
						@endforeach
					</div>	
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection