@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Recent Audit Logs') }}
						</div>
						
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="searchInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                   <div class="table table-responsive">
						
						<table class="table table-bordered table-striped" id="dataTable" >
							<thead>
								<tr>
									<th>#</th>
									<th>Event</th>
									<th>User</th>
									<th>Model</th>
									<th>Old Values</th>
									<th>New Values</th>
									<th>Date</th>
								</tr>
							</thead>
							<tbody>
								@forelse($audits as $index => $log)
									<tr>
										<td>{{ $index + 1 }}</td>
										<td>{{ ucfirst($log->event) }}</td>
										<td>{{ optional($log->user)->name ?? 'System' }}</td>
										<td>{{ class_basename($log->auditable_type) }} (ID: {{ $log->auditable_id }})</td>
										<td>
											@if($log->old_values)
												
													@if($log->old_values)
														<ul style="list-style-type:none;">
															@foreach($log->old_values as $field => $value)
																@if (in_array(pathinfo($value, PATHINFO_EXTENSION),['jpg','jpeg','png','pdf']) && !file_exists($value)) 
																<li><b>{{ $field }}:</b> <img src="{{ asset('storage/'.$value) }}" style="width:40px;height:40px;" > </li>
																@else
																<li><b>{{ $field }}:</b> {{ $value }}</li>	
																@endif
															@endforeach
														</ul>
													@else
														<em>—</em>
													@endif
													<!--
												<pre>{{ json_encode($log->old_values, JSON_PRETTY_PRINT) }}</pre>
													-->
											@else
												<em>—</em>
											@endif
										</td>
										<td>
											@if($log->new_values)
											
													@if($log->new_values)
														<ul style="list-style-type:none;">
															@foreach($log->new_values as $field => $value)
																@if (in_array(pathinfo($value, PATHINFO_EXTENSION),['jpg','jpeg','png','pdf']) && !file_exists($value)) 
																<li><b>{{ $field }}:</b> <img src="{{ asset('storage/'.$value) }}" style="width:40px;height:40px;" > </li>
																@else
																<li><b>{{ $field }}:</b> {{ $value }}</li>	
																@endif
															@endforeach
														</ul>
													@else
														<em>—</em>
													@endif
											<!--
												<pre>{{ json_encode($log->new_values, JSON_PRETTY_PRINT) }}</pre>
											-->
											@else
												<em>—</em>
											@endif
										</td>
										<td>{{ $log->created_at->format('d M Y, H:i:s') }}</td>
									</tr>
								@empty
									<tr>
										<td colspan="7" class="text-center">No audit logs found.</td>
									</tr>
								@endforelse
							</tbody>
						</table>
					</div>					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
document.getElementById('searchInput').addEventListener('keyup', function () {
  const searchTerm = this.value.toLowerCase();
  const rows = document.querySelectorAll('#dataTable tbody tr');

  rows.forEach(row => {
    const rowText = row.textContent.toLowerCase();
    row.style.display = rowText.includes(searchTerm) ? '' : 'none';
  });
});

</script>
@endsection