<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wardwise_docs', function (Blueprint $table) {
            $table->id();
			$table->string('filepath')->nullable(); // VARCHAR(255)           
			$table->string('file_ext')->nullable(); // VARCHAR(255) 
			$table->foreignId('elected_candidate_id')->nullable();	
			$table->foreignId('muncipal_corporation_id')->nullable();	
			$table->foreignId('final_voterlist_id')->nullable();	
			$table->foreignId('poling_stationwise_voterlist_id')->nullable();	
			$table->foreignId('nomination_ward_id')->nullable();	
			$table->foreignId('wardwise_election_result_id')->nullable();	
			$table->softDeletes(); // Adds 'deleted_at' column for soft deletes
			$table->unsignedBigInteger('created_by')->nullable();
			$table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wardwise_docs');
    }
};
