<?php
namespace App\Models;

class WardwiseDocs extends BaseModel
{
    protected $fillable = [        
        'filepath',
		'file_ext',       
        'elected_candidate_id',
        'poling_stationwise_voterlist_id',
        'nomination_ward_id',
        'final_voterlist_id',
        'muncipal_corporation_id',
        'wardwise_election_result_id',
    ];
	
	public function elected_candidate()
	{
		return $this->belongsTo(ElectedCandidates::class);
	}	
	
	public function poling_stationwise_voterlist()
	{
		return $this->belongsTo(PolingStationwiseVoterlist::class);
	}
	
	public function final_voterlist()
	{
		return $this->belongsTo(FinalVoterlist::class);
	}	
		
	public function nomination_ward()
	{
		return $this->belongsTo(NominationWard::class);
	}	
	
	public function muncipal_corporation()
	{
		return $this->belongsTo(MuncipalCorporation::class);
	}

	public function wardwise_election_result()
	{
		return $this->belongsTo(WardwiseElectionResult::class);
	}
}
