<?php
namespace App\Http\Controllers;

use App\Http\Requests\StoreWardwiseElectionResultRequest;
use App\Http\Requests\UpdateWardwiseElectionResultRequest;
use App\Models\WardwiseElectionResult;
use App\Models\WardwiseDocs;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;

class WardwiseElectionResultController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $wardwise_election_results =$general_election->wardwise_election_results;// WardwiseElectionResult::all();
        return view('wardwise_election_results.index', compact(['wardwise_election_results','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('wardwise_election_results.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreWardwiseElectionResultRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$wardwise_election_result=WardwiseElectionResult::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'general_election_id' =>$general_election->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'wardwise_election_result_id' => $wardwise_election_result->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
				
        return redirect()->route('wardwise_election_results.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(WardwiseElectionResult $wardwise_election_result)
    {
        return view('wardwise_election_results.edit', compact('wardwise_election_result'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(WardwiseElectionResult $wardwise_election_result)
    {
		//echo "<pre>";print_r($wardwise_election_result);echo "</pre>";die();
        return view('wardwise_election_results.edit', compact('wardwise_election_result'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateWardwiseElectionResultRequest $request, WardwiseElectionResult $wardwise_election_result)
    {
        $data = $request->validated();		 
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'wardwise_election_result_id' => $wardwise_election_result->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}
		
        $wardwise_election_result->update($data);
		
        return redirect()->route('wardwise_election_results.index',$wardwise_election_result->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WardwiseElectionResult $wardwise_election_result)
    {
        $wardwise_election_result->delete();
        return redirect()->route('wardwise_election_results.index',$wardwise_election_result->general_election);
    }
}
