<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreWardCompositionRequest;
use App\Http\Requests\UpdateWardCompositionRequest;
use App\Models\WardComposition;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;

class WardCompositionController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $ward_compositions = $general_election->ward_compositions;
		//echo "<pre>";print_r($ward_compositions);echo "</pre>";die();
        return view('ward_compositions.index', compact(['ward_compositions','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
        return view('ward_compositions.create',compact('general_election'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreWardCompositionRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($data);echo "</pre>";die();
				
		WardComposition::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'yearwise_population_en' => $data['yearwise_population_en'],			
			'yearwise_population_mr' => $data['yearwise_population_mr'],			
			'ward_major_places_en' => $data['ward_major_places_en'],			
			'ward_major_places_mr' => $data['ward_major_places_mr'],			
			'current_reservation_en' => $data['current_reservation_en'],			
			'current_reservation_mr' => $data['current_reservation_mr'],			
			'general_election_id' => $general_election->id,			
			'urlpath' => $data['urlpath'],			
		]);	
		
        return redirect()->route('ward_compositions.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(WardComposition $ward_composition)
    {
        return view('ward_compositions.edit', compact('ward_composition'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(WardComposition $ward_composition)
    {
        return view('ward_compositions.edit', compact('ward_composition'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateWardCompositionRequest $request, WardComposition $ward_composition)
    {
        $data = $request->validated();	

//var_dump($data);die();		
		
        $ward_composition->update($data);
		
        return redirect()->route('ward_compositions.index',$ward_composition->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WardComposition $ward_composition)
    {
        $ward_composition->delete();
        return redirect()->route('ward_compositions.index',$ward_composition->general_election);
    }
}
