<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreElectedCandidatesRequest;
use App\Http\Requests\UpdateElectedCandidatesRequest;
use App\Models\ElectedCandidates;
use App\Models\GeneralElection;
use App\Models\WardwiseDocs;
use Illuminate\Http\Request;
use App;
use Auth;

class ElectedCandidatesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $elected_candidates = $general_election->elected_candidates;//ElectedCandidates::all();
        return view('elected_candidates.index', compact(['elected_candidates','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('elected_candidates.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreElectedCandidatesRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$elected_candidate=ElectedCandidates::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'general_election_id' =>$general_election->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'elected_candidate_id' => $elected_candidate->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}			
		
        return redirect()->route('elected_candidates.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(ElectedCandidates $elected_candidate)
    {
        return view('elected_candidates.edit', compact('elected_candidate'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ElectedCandidates $elected_candidate)
    {
		//echo "<pre>";print_r($elected_candidate);echo "</pre>";die();
        return view('elected_candidates.edit', compact('elected_candidate'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateElectedCandidatesRequest $request, ElectedCandidates $elected_candidate)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'elected_candidate_id' => $elected_candidate->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
				
        $elected_candidate->update($data);
		
        return redirect()->route('elected_candidates.index',$elected_candidate->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ElectedCandidates $elected_candidate)
    {
        $elected_candidate->delete();
        return redirect()->route('elected_candidates.index',$elected_candidate->general_election);
    }
}
