@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
 
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
			<nav aria-label="breadcrumb">
			  <ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{route('general_elections.index')}}">General Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nagpur_muncipalelections.show',$nomination_ward->nomination_doc->general_election)}}">Nagpur Muncipal Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nomination_docs.index',$nomination_ward->nomination_doc->general_election)}}">Nomination Officers</a></li>
				<li class="breadcrumb-item"><a href="{{route('nomination_wards.index',$nomination_ward->nomination_doc)}}">Nomination wards</a></li>
				<li class="breadcrumb-item active" aria-current="page">Nomination ward docs</li>	
			  </ol>
			</nav>
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>{{ucfirst($nomination_ward->ward_en)}} Files </div>
						<div>
						</div>
					</div>
				</div>

                <div class="card-body p-5">
				
				
				<div class="row row-cols-1 row-cols-md-4 g-4">
					@foreach ($wardwise_docs as $wardwise_doc)
					  <div class="col">
						<div class="card h-100">
						  @if($wardwise_doc->file_ext=='pdf')
								<iframe src="{{ asset('storage/'.$wardwise_doc->filepath) }}" height="200px;" ></iframe>
						  @else
								<img src="{{asset('storage/'.$wardwise_doc->filepath)}}" class="card-img-top" alt="..." height="200px;">
						  @endif						  
						  <div class="card-footer">
							<small class="text-body-secondary d-flex justify-content-end">
								<!--
								<a href="{{ route('wardwise_docs.edit',$wardwise_doc) }}"><i class="fa-regular fa-edit"></i></a> 
								-->				
								<form action="{{ route('wardwise_docs.destroy', $wardwise_doc) }}" method="POST" style="display:inline;">
									@csrf
									<!-- @method('DELETE') -->
									<button style="border:none;" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
								</form>
							
							</small>
						  </div>
						</div>
					  </div>					  
					@endforeach
				</div>
				
                </div>
            </div>
        </div>
    </div>
</div>

@endsection