@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Latest News') }}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('latest_news.create') }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Title</th>
					<th class="text-center">File</th>
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
						@foreach ($latest_news as $latest_new)
						<tr>
							<td style="text-align:left">
							@if($currentLocale=='en')
								{{ $latest_new->title_en }}
							@else
								{{ $latest_new->title_mr }}	
							@endif
							</td>							
							<td class="text-center">
							@if($currentLocale=='en')
								<img src="{{ asset('storage/' . $latest_new->file_en) }}" alt="Image" style="width:40px;height:40px">
							@else
								<img src="{{ asset('storage/' . $latest_new->file_mr) }}" alt="Image" style="width:40px;height:40px">
							@endif
							</td>
							<td><a href="{{ route('latest_news.edit', $latest_new) }}"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="{{ route('latest_news.destroy', $latest_new) }}" method="POST" style="display:inline;">
								@csrf
								<!-- @method('DELETE') -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						@endforeach
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection