<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePolingStationwiseVoterlistRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
	public function rules(): array
    {
        return [
            'ward_en'=>'required',
            'ward_mr'=>'required',
			'file_en' => 'nullable|mimes:jpg,jpeg,png,pdf|max:2048',
			'file_mr' => 'nullable|mimes:jpg,jpeg,png,pdf|max:2048',
        ];
    }
	
	public function messages(): array
    {
        return [
            'ward_en.required'     => 'Please enter your title.',
            'ward_mr.required'     => 'Please enter your title.',
            'file_en.image' => 'The file must be an file.',
            'file_mr.image' => 'The file must be an file.',
			'file_en.mimes' => 'Allowed file_en types are: jpeg, png, jpg, gif, svg, pdf.',
			'file_mr.mimes' => 'Allowed file_mr types are: jpeg, png, jpg, gif, svg, pdf.',
			'file_en.max'   => 'The file_en size must not exceed 2MB.',            
			'file_mr.max'   => 'The file_mr size must not exceed 2MB.',            
        ];
    }
}
