<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreNominationDocsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
	public function rules(): array
    {
        return [
            'returning_officer_en'=>'required|unique:nomination_docs,returning_officer_en',
            'returning_officer_mr'=>'required|unique:nomination_docs,returning_officer_mr',
			'file_en' => 'nullable|mimes:jpg,jpeg,png,pdf|max:2048',
			'file_mr' => 'nullable|mimes:jpg,jpeg,png,pdf|max:2048',
        ];
    }
	
	public function messages(): array
    {
        return [
            'returning_officer_en.required'     => 'Please enter your title in english.',
            'returning_officer_mr.required'     => 'Please enter your title in marathi.',
            'file_en.image' => 'The file must be an file.',
            'file_mr.image' => 'The file must be an file.',
			'file_en.mimes' => 'Allowed file_en types are: jpeg, png, jpg, gif, svg, pdf.',
			'file_mr.mimes' => 'Allowed file_mr types are: jpeg, png, jpg, gif, svg, pdf.',
			'file_en.max'   => 'The file_en size must not exceed 2MB.',            
			'file_mr.max'   => 'The file_mr size must not exceed 2MB.',            
        ];
    }
}
