<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreLatestNewsRequest;
use App\Http\Requests\UpdateLatestNewsRequest;
use App\Models\LatestNews;
use Illuminate\Http\Request;
use App;

class LatestNewsController extends Controller
{
   /**
     * Display a listing of the resource.
     */
    public function index()
    {
		$currentLocale = App::getLocale();
        $latest_news = LatestNews::all();
        return view('latest_news.index', compact(['latest_news','currentLocale']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('latest_news.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreLatestNewsRequest  $request)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');

			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		LatestNews::create([
			'title_en' => $data['title_en'],
			'title_mr' => $data['title_mr'],			
			'file_en' => $path_en,
			'file_mr' => $path_mr,
		]);	
		
        return redirect()->route('latest_news.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(LatestNews $mainMenu)
    {
        return view('latest_news.edit', compact('latest_new'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(LatestNews $latest_new)
    {
        return view('latest_news.edit', compact('latest_new'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateLatestNewsRequest $request, LatestNews $latest_new)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');

			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
		}
		
		
		
		
		
        $latest_new->update($data);
		
        return redirect()->route('latest_news.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(LatestNews $latest_new)
    {
        $latest_new->delete();
        return redirect()->route('latest_news.index');
    }
}
