<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreGeneralElectionRequest;
use App\Http\Requests\UpdateGeneralElectionRequest;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;
use Auth;

class GeneralElectionController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
		$currentLocale = App::getLocale();
        $general_elections = GeneralElection::all();
        return view('general_elections.index', compact(['general_elections','currentLocale']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('general_elections.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreGeneralElectionRequest  $request)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
				
		GeneralElection::create([
			'title_en' => $data['title_en'],
			'title_mr' => $data['title_mr']			
		]);	
		
        return redirect()->route('general_elections.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(GeneralElection $general_election)
    {
        return view('general_elections.edit', compact('general_election'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(GeneralElection $general_election)
    {
        return view('general_elections.edit', compact('general_election'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateGeneralElectionRequest $request, GeneralElection $general_election)
    {
        $data = $request->validated();	

//var_dump($data);die();		
		
        $general_election->update($data);
		
        return redirect()->route('general_elections.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(GeneralElection $general_election)
    {
        $general_election->delete();
        return redirect()->route('general_elections.index');
    }
}
