
<?php $__env->startSection('content'); ?>
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							<?php echo e(__('Ward Composition')); ?>

						</div>
						<div>
							<a style="text-decoration:none;" href="<?php echo e(route('ward_compositions.create',$general_election)); ?>">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Ward(Name & No)</th>
					<th>Population(as per <?php echo e($general_election->created_at); ?> census)</th>
					<th>Major places in the ward</th>
					<th>Current reservation</th>
					<th>Url</th>
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
					<?php if(!empty($ward_compositions)): ?>
						<?php $__currentLoopData = $ward_compositions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward_composition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td style="text-align:left">
								<a href="<?php echo e(route('nagpur_muncipalelections.show',$ward_composition)); ?>">
									<?php if($currentLocale=='en'): ?>
										<?php echo e($ward_composition->ward_en); ?>

									<?php else: ?>
										<?php echo e($ward_composition->ward_mr); ?>	
									<?php endif; ?>
								</a>
							</td>
							<td style="text-align:left">
								<a href="<?php echo e(route('nagpur_muncipalelections.show',$ward_composition)); ?>">
									<?php if($currentLocale=='en'): ?>
										<?php echo e($ward_composition->yearwise_population_en); ?>

									<?php else: ?>
										<?php echo e($ward_composition->yearwise_population_mr); ?>	
									<?php endif; ?>
								</a>
							</td>
							
							<td style="text-align:left">
								<a href="<?php echo e(route('nagpur_muncipalelections.show',$ward_composition)); ?>">
									<?php if($currentLocale=='en'): ?>
										<?php echo e($ward_composition->ward_major_places_en); ?>

									<?php else: ?>
										<?php echo e($ward_composition->ward_major_places_mr); ?>	
									<?php endif; ?>
								</a>
							</td>
							
							<td style="text-align:left">
								<a href="<?php echo e(route('nagpur_muncipalelections.show',$ward_composition)); ?>">
									<?php if($currentLocale=='en'): ?>
										<?php echo e($ward_composition->current_reservation_en); ?>

									<?php else: ?>
										<?php echo e($ward_composition->current_reservation_mr); ?>	
									<?php endif; ?>
								</a>
							</td>
								
							<td style="text-align:left">
								<a href="<?php echo e(route('nagpur_muncipalelections.show',$ward_composition)); ?>">
								
										<?php echo e($ward_composition->urlpath); ?>

									
								</a>
							</td>
							
							
							<td>
								<a href="<?php echo e(route('ward_compositions.edit', $ward_composition)); ?>"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="<?php echo e(route('ward_compositions.destroy', $ward_composition)); ?>" method="POST" style="display:inline;">
								<?php echo csrf_field(); ?>
								<!-- <?php echo method_field('DELETE'); ?> -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>	
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\nmc-elections\resources\views/ward_compositions/index.blade.php ENDPATH**/ ?>