<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
<!-- Font Awesome CSS (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">


<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.min.js" integrity="sha384-7qAoOXltbVP82dhxHAUje59V5r2YsVfBafyUDxEdApLPmcdhBPg1DKg1ERo0BZlK" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
   <!-- Scripts -->
<style>
.pointer{
	cursor:pointer;
}
</style>
</head>
<body>
    <div id="app">
        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
				<?php if(Auth::user()): ?>					
					<?php if(auth()->user()->hasRole('superadmin')): ?>				
						<a class="navbar-brand" href="<?php echo e(url('/superadmin/home')); ?>">
							<?php echo e(config('app.name', 'Laravel')); ?>

						</a>
					<?php elseif(auth()->user()->hasRole('admin')): ?>				
						 <a class="navbar-brand" href="<?php echo e(url('/admin/adminhome')); ?>">
							<?php echo e(config('app.name', 'Laravel')); ?>

						</a>
					<?php elseif(auth()->user()->hasRole('user')): ?>				
						 <a class="navbar-brand" href="<?php echo e(url('/user/userhome')); ?>">
							<?php echo e(config('app.name', 'Laravel')); ?>

						</a>
					<?php endif; ?>		
				<?php else: ?>
					<a class="navbar-brand" href="<?php echo e(url('/')); ?>">
						<?php echo e(config('app.name', 'Laravel')); ?>

					</a>	
				<?php endif; ?>
				
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav me-auto">
						<!-- <li class="nav-item">
							<a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
						</li> -->
					</ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ms-auto">
					<li class="nav-item d-flex justify-content-center align-items-center">						
						<a href="<?php echo e(url('lang/en')); ?>" class="link-info" style="margin-right:5px;text-decoration:none;" >English</a> | <a class="link-warning" style="margin-left:5px;text-decoration:none;margin-right:30px;" href="<?php echo e(url('lang/mr')); ?>">मराठी</a>
					</li>
                        <!-- Authentication Links -->
                        <?php if(auth()->guard()->guest()): ?>
                            <?php if(Route::has('login')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(Route::has('register')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php else: ?>
											
							<?php if(Auth::user()->hasRole('superadmin')): ?>
								
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <i class="fa fa-upload"></i>&nbsp;<?php echo e(__('Muncipal Corporation')); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(route('latest_news.index')); ?>"><?php echo e(__('Latest News')); ?></a>                                    
                               
                                    <a class="dropdown-item" href="<?php echo e(route('general_elections.index')); ?>"><?php echo e(__('General Elections')); ?></a>                                    
                                    <a class="dropdown-item" href="<?php echo e(route('audits.index')); ?>"><?php echo e(__('User Logs')); ?></a>                                    
                                </div>
                            </li>							
								
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <i class="fa fa-cog"></i>&nbsp;<?php echo e(__('Settings')); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(route('configs.index')); ?>"><?php echo e(__('Configs')); ?></a>
                                    <a class="dropdown-item" href="<?php echo e(route('roles.index')); ?>"><?php echo e(__('Roles')); ?></a>
                                    <a class="dropdown-item" href="<?php echo e(route('users.index')); ?>"><?php echo e(__('Users')); ?></a>                                    
                                </div>
                            </li>
							<?php endif; ?>
								
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <?php echo e(Auth::user()->name); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>

        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\nmc-elections\resources\views/layouts/app.blade.php ENDPATH**/ ?>