<?php

use Illuminate\Support\Facades\Route;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\ElectedCandidatesController;
use App\Http\Controllers\MuncipalCorporationController;
use App\Http\Controllers\NominationDocsController;
use App\Http\Controllers\wardCompositionController;
use App\Http\Controllers\GeneralElectionController;
use App\Http\Controllers\NagpurMuncipalelectionController;
use App\Http\Controllers\PolingStationwiseVoterlistController;
use App\Http\Controllers\FinalVoterlistController;
use App\Http\Controllers\WardwiseElectionResultController;
use App\Http\Controllers\WardwiseDocsController;
use App\Http\Controllers\NominationWardController;
use App\Http\Controllers\LatestNewsController;
use App\Http\Controllers\ConfigsController;
use App\Http\Controllers\PublicController;
use App\Http\Controllers\AuditController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

/* Route::get('/', function () {
    return view('welcome');
}); */

	Route::get('/', [PublicController::class, 'welcome'])->name('welcome');
	Route::get('/about', [PublicController::class, 'about'])->name('about');
	Route::get('/nmc_welcome', [PublicController::class, 'nmcWelcome'])->name('nmc_welcome');
	Route::get('/election_view/{general_election}', [PublicController::class, 'electionView'])->name('election_view');
	
	Route::get('/wardwise_election_results/{general_election}', [PublicController::class, 'wardwiseElectionResult'])->name('wardwise_election_results');
	Route::get('/wardwise_election_results/wardwise_documents/{wardwise_election_result}', [PublicController::class, 'wardwiseElectionResultDocs'])->name('wardwise_election_results.wardwise_documents');
	Route::get('/wardwise_election_results/wardwise_document_view/{id}', [PublicController::class, 'wardwiseElectionResultDocView'])->name('wardwise_election_results.wardwise_document_view');
		
	Route::get('/muncipal_corporations/{general_election}', [PublicController::class, 'muncipalCorporation'])->name('muncipal_corporations');
	Route::get('/muncipal_corporations/wardwise_documents/{muncipal_corporation}', [PublicController::class, 'muncipalCorporationDocs'])->name('muncipal_corporations.wardwise_documents');
	Route::get('/muncipal_corporations/wardwise_document_view/{id}', [PublicController::class, 'muncipalCorporationDocView'])->name('muncipal_corporations.wardwise_document_view');
		
	Route::get('/final_voterlists/{general_election}', [PublicController::class, 'finalVoterlist'])->name('final_voterlists');
	Route::get('/final_voterlists/wardwise_documents/{final_voterlist}', [PublicController::class, 'finalVoterlistDocs'])->name('final_voterlists.wardwise_documents');
	Route::get('/final_voterlists/wardwise_document_view/{id}', [PublicController::class, 'finalVoterlistDocView'])->name('final_voterlists.wardwise_document_view');
	
	Route::get('/poling_stationwise_voterlists/{general_election}', [PublicController::class, 'polingStationwiseVoterlist'])->name('poling_stationwise_voterlists');
	Route::get('/poling_stationwise_voterlists/wardwise_documents/{poling_stationwise_voterlist}', [PublicController::class, 'polingStationwiseVoterlistDocs'])->name('poling_stationwise_voterlists.wardwise_documents');
	Route::get('/poling_stationwise_voterlists/wardwise_document_view/{id}', [PublicController::class, 'polingStationwiseVoterlistDocView'])->name('poling_stationwise_voterlists.wardwise_document_view');
	
	Route::get('/elected_candidates/{general_election}', [PublicController::class, 'electedCandidates'])->name('elected_candidates');
	Route::get('/elected_candidates/wardwise_documents/{elected_candidate}', [PublicController::class, 'electedCandidateDocs'])->name('elected_candidates.wardwise_documents');
	Route::get('/elected_candidates/wardwise_document_view/{id}', [PublicController::class, 'electedCandidateDocView'])->name('elected_candidates.wardwise_document_view');
	
	Route::get('/ward_composition/{general_election}', [PublicController::class, 'wardComposition'])->name('ward_composition');
	
	Route::get('/nomination_wards/{nomination_doc}', [PublicController::class, 'nominationWards'])->name('nomination_wards');
	
	Route::get('/nomination_wards/wardwise_documents/{nomination_ward}', [PublicController::class, 'nominationWardDocs'])->name('nomination_wards.wardwise_documents');
	Route::get('/nomination_wards/wardwise_document_view/{id}', [PublicController::class, 'nominationWardDocView'])->name('nomination_wards.wardwise_document_view');
	




Auth::routes();


Route::middleware(['auth'])->prefix('superadmin')->group(function () {
	Route::get('/home', [HomeController::class, 'index'])->name('superadmins.home');
   
	// Users
	Route::get('/users/index', [UserController::class, 'index'])->name('users.index');
	Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
	Route::post('/users/store', [UserController::class, 'store'])->name('users.store');
	Route::get('/users/edit/{role}', [UserController::class, 'edit'])->name('users.edit');
	Route::post('/users/update/{role}', [UserController::class, 'update'])->name('users.update');
	Route::post('/users/destroy/{role}', [UserController::class, 'destroy'])->name('users.destroy');

	// Roles
	Route::get('/roles/index', [RoleController::class, 'index'])->name('roles.index');
	Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
	Route::post('/roles/store', [RoleController::class, 'store'])->name('roles.store');
	Route::get('/roles/edit/{role}', [RoleController::class, 'edit'])->name('roles.edit');
	Route::post('/roles/update/{role}', [RoleController::class, 'update'])->name('roles.update');
	Route::post('/roles/destroy/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');

	// Elected Candidates   
	Route::get('/elected_candidates/index/{general_election}', [ElectedCandidatesController::class, 'index'])->name('elected_candidates.index');
	Route::get('/elected_candidates/create/{general_election}', [ElectedCandidatesController::class, 'create'])->name('elected_candidates.create');
	Route::post('/elected_candidates/store/{general_election}', [ElectedCandidatesController::class, 'store'])->name('elected_candidates.store');
	Route::get('/elected_candidates/edit/{elected_candidate}', [ElectedCandidatesController::class, 'edit'])->name('elected_candidates.edit');
	Route::post('/elected_candidates/update/{elected_candidate}', [ElectedCandidatesController::class, 'update'])->name('elected_candidates.update');
	Route::post('/elected_candidates/destroy/{elected_candidate}', [ElectedCandidatesController::class, 'destroy'])->name('elected_candidates.destroy');

	// Polling station wise voter list   
	Route::get('/poling_stationwise_voterlists/index/{general_election}', [PolingStationwiseVoterlistController::class, 'index'])->name('poling_stationwise_voterlists.index');
	Route::get('/poling_stationwise_voterlists/create/{general_election}', [PolingStationwiseVoterlistController::class, 'create'])->name('poling_stationwise_voterlists.create');
	Route::post('/poling_stationwise_voterlists/store/{general_election}', [PolingStationwiseVoterlistController::class, 'store'])->name('poling_stationwise_voterlists.store');
	Route::get('/poling_stationwise_voterlists/edit/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'edit'])->name('poling_stationwise_voterlists.edit');
	Route::post('/poling_stationwise_voterlists/update/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'update'])->name('poling_stationwise_voterlists.update');
	Route::post('/poling_stationwise_voterlists/destroy/{poling_stationwise_voterlist}', [PolingStationwiseVoterlistController::class, 'destroy'])->name('poling_stationwise_voterlists.destroy');

	// Final voter list   
	Route::get('/final_voterlists/index/{general_election}', [FinalVoterlistController::class, 'index'])->name('final_voterlists.index');
	Route::get('/final_voterlists/create/{general_election}', [FinalVoterlistController::class, 'create'])->name('final_voterlists.create');
	Route::post('/final_voterlists/store/{general_election}', [FinalVoterlistController::class, 'store'])->name('final_voterlists.store');
	Route::get('/final_voterlists/edit/{final_voterlist}', [FinalVoterlistController::class, 'edit'])->name('final_voterlists.edit');
	Route::post('/final_voterlists/update/{final_voterlist}', [FinalVoterlistController::class, 'update'])->name('final_voterlists.update');
	Route::post('/final_voterlists/destroy/{final_voterlist}', [FinalVoterlistController::class, 'destroy'])->name('final_voterlists.destroy');

	// Wardwise Election Result  
	Route::get('/wardwise_election_results/index/{general_election}', [WardwiseElectionResultController::class, 'index'])->name('wardwise_election_results.index');
	Route::get('/wardwise_election_results/create/{general_election}', [WardwiseElectionResultController::class, 'create'])->name('wardwise_election_results.create');
	Route::post('/wardwise_election_results/store/{general_election}', [WardwiseElectionResultController::class, 'store'])->name('wardwise_election_results.store');
	Route::get('/wardwise_election_results/edit/{wardwise_election_result}', [WardwiseElectionResultController::class, 'edit'])->name('wardwise_election_results.edit');
	Route::post('/wardwise_election_results/update/{wardwise_election_result}', [WardwiseElectionResultController::class, 'update'])->name('wardwise_election_results.update');
	Route::post('/wardwise_election_results/destroy/{wardwise_election_result}', [WardwiseElectionResultController::class, 'destroy'])->name('wardwise_election_results.destroy');

	// Muncipal Corporations
	Route::get('/muncipal_corporations/index/{general_election}', [MuncipalCorporationController::class, 'index'])->name('muncipal_corporations.index');
	Route::get('/muncipal_corporations/create/{general_election}', [MuncipalCorporationController::class, 'create'])->name('muncipal_corporations.create');
	Route::post('/muncipal_corporations/store/{general_election}', [MuncipalCorporationController::class, 'store'])->name('muncipal_corporations.store');
	Route::get('/muncipal_corporations/edit/{muncipal_corporation}', [MuncipalCorporationController::class, 'edit'])->name('muncipal_corporations.edit');
	Route::post('/muncipal_corporations/update/{muncipal_corporation}', [MuncipalCorporationController::class, 'update'])->name('muncipal_corporations.update');
	Route::post('/muncipal_corporations/destroy/{muncipal_corporation}', [MuncipalCorporationController::class, 'destroy'])->name('muncipal_corporations.destroy');

	// Nomination Docs
	Route::get('/nomination_docs/index/{general_election}', [NominationDocsController::class, 'index'])->name('nomination_docs.index');
	Route::get('/nomination_docs/create/{general_election}', [NominationDocsController::class, 'create'])->name('nomination_docs.create');
	Route::post('/nomination_docs/store/{general_election}', [NominationDocsController::class, 'store'])->name('nomination_docs.store');
	Route::get('/nomination_docs/edit/{nomination_doc}', [NominationDocsController::class, 'edit'])->name('nomination_docs.edit');
	Route::post('/nomination_docs/update/{nomination_doc}', [NominationDocsController::class, 'update'])->name('nomination_docs.update');
	Route::post('/nomination_docs/destroy/{nomination_doc}', [NominationDocsController::class, 'destroy'])->name('nomination_docs.destroy');
	
	// Ward Composition
	Route::get('/ward_compositions/index/{general_election}', [WardCompositionController::class, 'index'])->name('ward_compositions.index');
	Route::get('/ward_compositions/create/{general_election}', [WardCompositionController::class, 'create'])->name('ward_compositions.create');
	Route::post('/ward_compositions/store/{general_election}', [WardCompositionController::class, 'store'])->name('ward_compositions.store');
	Route::get('/ward_compositions/edit/{ward_composition}', [WardCompositionController::class, 'edit'])->name('ward_compositions.edit');
	Route::post('/ward_compositions/update/{ward_composition}', [WardCompositionController::class, 'update'])->name('ward_compositions.update');
	Route::post('/ward_compositions/destroy/{ward_composition}', [WardCompositionController::class, 'destroy'])->name('ward_compositions.destroy');

	// General Elections
	Route::get('/general_elections/index', [GeneralElectionController::class, 'index'])->name('general_elections.index');
	Route::get('/general_elections/create', [GeneralElectionController::class, 'create'])->name('general_elections.create');
	Route::post('/general_elections/store', [GeneralElectionController::class, 'store'])->name('general_elections.store');
	Route::get('/general_elections/edit/{general_election}', [GeneralElectionController::class, 'edit'])->name('general_elections.edit');
	Route::post('/general_elections/update/{general_election}', [GeneralElectionController::class, 'update'])->name('general_elections.update');
	Route::post('/general_elections/destroy/{general_election}', [GeneralElectionController::class, 'destroy'])->name('general_elections.destroy');

	// Nomination Wards
	Route::get('/nomination_wards/index/{nomination_doc}', [NominationWardController::class, 'index'])->name('nomination_wards.index');
	Route::get('/nomination_wards/create/{nomination_doc}', [NominationWardController::class, 'create'])->name('nomination_wards.create');
	Route::post('/nomination_wards/store/{nomination_doc}', [NominationWardController::class, 'store'])->name('nomination_wards.store');
	Route::get('/nomination_wards/edit/{nomination_ward}', [NominationWardController::class, 'edit'])->name('nomination_wards.edit');
	Route::post('/nomination_wards/update/{nomination_ward}', [NominationWardController::class, 'update'])->name('nomination_wards.update');
	Route::post('/nomination_wards/destroy/{nomination_ward}', [NominationWardController::class, 'destroy'])->name('nomination_wards.destroy');

	// Latest News
	Route::get('/latest_news/index', [LatestNewsController::class, 'index'])->name('latest_news.index');
	Route::get('/latest_news/create', [LatestNewsController::class, 'create'])->name('latest_news.create');
	Route::post('/latest_news/store', [LatestNewsController::class, 'store'])->name('latest_news.store');
	Route::get('/latest_news/edit/{latest_new}', [LatestNewsController::class, 'edit'])->name('latest_news.edit');
	Route::post('/latest_news/update/{latest_new}', [LatestNewsController::class, 'update'])->name('latest_news.update');
	Route::post('/latest_news/destroy/{latest_new}', [LatestNewsController::class, 'destroy'])->name('latest_news.destroy');

	// Configs
	Route::get('/configs/index', [ConfigsController::class, 'index'])->name('configs.index');
	Route::get('/configs/create', [ConfigsController::class, 'create'])->name('configs.create');
	Route::post('/configs/store', [ConfigsController::class, 'store'])->name('configs.store');
	Route::get('/configs/edit/{config}', [ConfigsController::class, 'edit'])->name('configs.edit');
	Route::post('/configs/update/{config}', [ConfigsController::class, 'update'])->name('configs.update');
	Route::post('/configs/destroy/{config}', [ConfigsController::class, 'destroy'])->name('configs.destroy');

	// Nagpur Muncipalelections
	Route::get('/nagpur_muncipalelections/show/{general_election}', [NagpurMuncipalelectionController::class, 'show'])->name('nagpur_muncipalelections.show');
	
	// Wardwise Docs
	Route::get('/wardwise_docs/show/{elected_candidate}', [WardwiseDocsController::class, 'show'])->name('wardwise_docs.show');
	Route::get('/wardwise_docs/pswvl_show/{poling_stationwise_voterlist}', [WardwiseDocsController::class, 'pswvlShow'])->name('wardwise_docs.pswvl_show');
	Route::get('/wardwise_docs/fvl_show/{final_voterlist}', [WardwiseDocsController::class, 'fvlShow'])->name('wardwise_docs.fvl_show');
	Route::get('/wardwise_docs/mc_show/{muncipal_corporation}', [WardwiseDocsController::class, 'mcShow'])->name('wardwise_docs.mc_show');
	Route::get('/wardwise_docs/wwer_show/{wardwise_election_result}', [WardwiseDocsController::class, 'wwerShow'])->name('wardwise_docs.wwer_show');
	Route::get('/wardwise_docs/nd_show/{nomination_ward}', [WardwiseDocsController::class, 'ndShow'])->name('wardwise_docs.nd_show');
	
		
	Route::get('/wardwise_docs/edit/{wardwise_doc}', [WardwiseDocsController::class, 'edit'])->name('wardwise_docs.edit');
	Route::post('/wardwise_docs/update/{wardwise_doc}', [WardwiseDocsController::class, 'update'])->name('wardwise_docs.update');
	Route::post('/wardwise_docs/destroy/{wardwise_doc}', [WardwiseDocsController::class, 'destroy'])->name('wardwise_docs.destroy');
	
	//audit
	Route::get('/audits/index', [AuditController::class, 'index'])->name('audits.index');
   
    // Add more admin routes here
});
Route::middleware(['auth'])->prefix('admin')->group(function () {
   Route::get('/adminhome', [HomeController::class, 'adminIndex'])->name('admins.adminhome');
    // Add more admin routes here
}); 
Route::middleware(['auth'])->prefix('user')->group(function () {
   Route::get('/userhome', [HomeController::class, 'userIndex'])->name('users.userhome');
    // Add more admin routes here
}); 


//download
Route::get('/download/{filename}', [PublicController::class, 'downloadFile'])->name('file.download');


// Language 
Route::get('lang/{locale}', function ($locale) {
    if (!in_array($locale, ['en', 'mr'])) {
        abort(400);
    }

    App::setLocale($locale);
    Session::put('locale', $locale);

    return redirect()->back();
});