@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Ward Composition') }}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('ward_compositions.create',$general_election) }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Ward(Name & No)</th>
					<th>Population(as per {{$general_election->created_at}} census)</th>
					<th>Major places in the ward</th>
					<th>Current reservation</th>
					<th>Url</th>
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
					@if(!empty($ward_compositions))
						@foreach($ward_compositions as $ward_composition)
						<tr>
							<td style="text-align:left">
								<a href="{{route('nagpur_muncipalelections.show',$ward_composition)}}">
									@if($currentLocale=='en')
										{{ $ward_composition->ward_en }}
									@else
										{{ $ward_composition->ward_mr }}	
									@endif
								</a>
							</td>
							<td style="text-align:left">
								<a href="{{route('nagpur_muncipalelections.show',$ward_composition)}}">
									@if($currentLocale=='en')
										{{ $ward_composition->yearwise_population_en }}
									@else
										{{ $ward_composition->yearwise_population_mr }}	
									@endif
								</a>
							</td>
							
							<td style="text-align:left">
								<a href="{{route('nagpur_muncipalelections.show',$ward_composition)}}">
									@if($currentLocale=='en')
										{{ $ward_composition->ward_major_places_en }}
									@else
										{{ $ward_composition->ward_major_places_mr }}	
									@endif
								</a>
							</td>
							
							<td style="text-align:left">
								<a href="{{route('nagpur_muncipalelections.show',$ward_composition)}}">
									@if($currentLocale=='en')
										{{ $ward_composition->current_reservation_en }}
									@else
										{{ $ward_composition->current_reservation_mr }}	
									@endif
								</a>
							</td>
								
							<td style="text-align:left">
								<a href="{{route('nagpur_muncipalelections.show',$ward_composition)}}">
								
										{{ $ward_composition->urlpath }}
									
								</a>
							</td>
							
							
							<td>
								<a href="{{ route('ward_compositions.edit', $ward_composition) }}"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="{{ route('ward_compositions.destroy', $ward_composition) }}" method="POST" style="display:inline;">
								@csrf
								<!-- @method('DELETE') -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						@endforeach
					@endif	
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection