@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Main Menu') }}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('main_menus.create') }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Title</th>
					<th>Headline</th>
					<th class="text-center">Image</th>
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
						@foreach ($main_menus as $main_menu)
						<tr>
							<td style="text-align:left">
							@if($currentLocale=='en')
								{{ $main_menu->title_en }}
							@else
								{{ $main_menu->title_mr }}	
							@endif
							</td>
							<td style="text-align:left">
							@if($currentLocale=='en')
								{{ $main_menu->headline_en }}
							@else
								{{ $main_menu->headline_mr }}	
							@endif
							</td>
							<td class="text-center">
							@if($currentLocale=='en')
								<img src="{{ asset('storage/' . $main_menu->image_en) }}" alt="Image" style="width:40px;height:40px">
							@else
								<img src="{{ asset('storage/' . $main_menu->image_mr) }}" alt="Image" style="width:40px;height:40px">
							@endif
							</td>
							<td><a href="{{ route('main_menus.edit', $main_menu) }}"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="{{ route('main_menus.destroy', $main_menu) }}" method="POST" style="display:inline;">
								@csrf
								<!-- @method('DELETE') -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						@endforeach
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection