@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center1;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
			<nav aria-label="breadcrumb">
			  <ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{route('general_elections.index')}}">General Elections</a></li>
					<li class="breadcrumb-item active" aria-current="page">Nagpur General Elections</li>
			  </ol>
			</nav>
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							@if($currentLocale == 'en')
								{{$general_election->title_en}}
							@else
								{{$general_election->title_mr}}
							@endif
						</div>						
					</div>
				</div>

                <div class="card-body">
					<!--
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    -->
					<table class="table table-bordered table-striped">
					
					<tbody id="myTable">
						<tr>
							
							<td>							
									
								<a href="{{ route('wardwise_election_results.index', $general_election) }}">{{__('labels.ward_wise_election_results')}}</a>
																
							</td>
							
						</tr>	
						<tr>
							
							<td>								
									
								<a href="{{ route('muncipal_corporations.index', $general_election) }}">{{__('labels.nagpur_muncipal_corporation')}}</a>
																
							</td>
							
						</tr>
						<tr>
							
							<td>								
									
								<a href="{{ route('final_voterlists.index', $general_election) }}">{{__('labels.final_voter_list')}}</a>
																	
							</td>
							
						</tr>	
						<tr>
							
							<td>
																	
								<a href="{{ route('poling_stationwise_voterlists.index', $general_election) }}">{{__('labels.poling_station_wise_voter_list')}}</a>
																
							</td>
							
						</tr>
						
						<tr>
							
							<td>
															
								<a href="{{ route('elected_candidates.index', $general_election) }}">{{__('labels.list_of_elected_candidates')}}</a>
																
							</td>
							
						</tr>

						<tr>
							
							<td>
																
								<a href="{{ route('nomination_docs.index', $general_election) }}">{{__('labels.candidates_nomination_letter_and_documents')}}</a>
																
							</td>
							
						</tr>
						<tr>
							
							<td>
																	
								<a href="{{ route('ward_compositions.index', $general_election) }}">{{__('labels.ward_composition')}}</a>
																
							</td>
							
						</tr>
						
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection