@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							Add Content
						</div>
						<div>
							<a style="text-decoration:none;" href="{{route('configs.index')}}">Back</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<form method="POST" action="{{route('configs.store') }}" file="true" enctype="multipart/form-data">
						@csrf
						<div class="p-3">
							<div class="mb-3">
								<label for="content_en" class="form-label">{{__('labels.content_en')}}</label>
								
								<textarea class="form-control" rows="5" id="content_en" name="content_en"  placeholder="enter english content" ></textarea>
								
								@error('content_en')
									<small class="text-danger">{{ $message }}</small>
								@enderror 							
							</div>
							<div class="mb-3">
								<label for="content_mr" class="form-label">{{__('labels.content_mr')}}</label>
								<textarea class="form-control" rows="5" id="content_mr" name="content_mr"  placeholder="enter marathi content" ></textarea>
								@error('content_mr')
									<small class="text-danger">{{ $message }}</small>
								@enderror
							</div>	
							
							<div class="mb-3">
							  <label for="banner" class="form-label">{{__('labels.banner')}}</label>
							  <input type="file" class="form-control" id="banner" name="banner" accept="image/*" placeholder="enter english image">
							</div>					
							
							<div class="py-3 text-center">
							 
							<button class="btn btn-success  btn-sm mb-1" type="submit">Add</button>

							</div>
						
						</div>
					</form>				
                </div>
            </div>
        </div>
    </div>
</div>
@endsection