<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_elections', function (Blueprint $table) {
            $table->id();
			$table->string('title_en'); // VARCHAR(255)           
			$table->string('title_mr')->nullable(); // VARCHAR(255)  
		    $table->softDeletes(); // Adds 'deleted_at' column for soft deletes
            $table->unsignedBigInteger('created_by')->nullable();
			$table->unsignedBigInteger('updated_by')->nullable();
			$table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_elections');
    }
};
