<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateWardCompositionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         return [
			'ward_en'=>'required',
			'ward_mr'=>'required',
			'yearwise_population_en'=>'',
			'yearwise_population_mr'=>'',        
			'ward_major_places_en'=>'',
			'ward_major_places_mr'=>'',
			'current_reservation_en'=>'',      
			'current_reservation_mr'=>'', 		
			'urlpath'=>'',	
        ];
    }
	
	public function messages(): array
    {
        return [
            'ward_en.required'     => 'Please enter your ward and number.',
            'ward_mr.required'     => 'Please enter your ward and number',                  
        ];
    }
}
