<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateConfigsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
     /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'content_en' => 'required',
            'content_mr' => 'required',
            'banner' => 'nullable|mimes:jpg,jpeg,png,pdf|max:2048',
        ];
    }
	
	public function messages(): array
    {
        return [
            'content_en.required'     => 'Please enter your title.',
            'content_mr.required'     => 'Please enter your title.',
            'banner.image' => 'The file must be an file.',         
			'banner.mimes' => 'Allowed file_en types are: jpeg, png, jpg, gif, svg.',		
			'banner.max'   => 'The file_en size must not exceed 2MB.',            
			
        ];
    }
}
