<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\GeneralElection;
use App\Models\WardwiseDocs;
use App\Models\ElectedCandidates;
use App\Models\FinalVoterlist;
use App\Models\WardwiseElectionResult;
use App\Models\MuncipalCorporation;
use App\Models\PolingStationwiseVoterlist;
use App\Models\NominationWard;
use App\Models\NominationDocs;
use App\Models\LatestNews;
use Illuminate\Support\Facades\Storage;
use App;

class PublicController extends Controller
{
    
	public function welcome()
    {
		$currentLocale = App::getLocale();
		$general_elections=GeneralElection::all();
        return view('welcome',compact(['general_elections','currentLocale']));
    } 
	
	public function nmcWelcome()
    {
		$currentLocale = App::getLocale();
		$general_elections=GeneralElection::all();
		$latest_news=LatestNews::all();
        return view('nmc_welcome',compact(['general_elections','currentLocale','latest_news']));
    }    
	public function about()
    {
		$currentLocale = App::getLocale();
		$general_elections=GeneralElection::all();
        return view('about',compact(['general_elections','currentLocale']));
    } 
	
	public function electionView(GeneralElection $general_election)
    {		
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
		//echo "<pre>";print_r($general_election);echo "</pre>";die();
        return view('election_view',compact(['general_election','currentLocale','nomination_docs']));
    }	
	
// elected candidates
	
	public function electedCandidates(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
        return view('elected_candidates',compact(['general_election','currentLocale','nomination_docs']));
    }	
	
	public function electedCandidateDocs(ElectedCandidates $elected_candidate)
    {
		$wardwise_documents=$elected_candidate->wardwise_docs;
		$currentLocale = App::getLocale();
		$nomination_docs=$elected_candidate->general_election->nomination_docs;
		$general_election=$elected_candidate->general_election;
        return view('elected_candidates.wardwise_documents',compact(['nomination_docs','wardwise_documents','currentLocale','elected_candidate','general_election']));
    }	
	
	public function electedCandidateDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$general_election=$wardwise_doc->elected_candidate->general_election;
		$nomination_docs=$wardwise_doc->elected_candidate->general_election->nomination_docs;
        return view('elected_candidates.wardwise_document_view',compact(['nomination_docs','wardwise_doc','currentLocale','general_election']));
    }	
	
// poling station wise voter list
	
	public function polingStationwiseVoterlist(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
        return view('poling_stationwise_voterlists',compact(['nomination_docs','general_election','currentLocale']));
    }	
	
	public function polingStationwiseVoterlistDocs(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
		$wardwise_documents=$poling_stationwise_voterlist->wardwise_docs;
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$poling_stationwise_voterlist->general_election->nomination_docs;
		$general_election=$poling_stationwise_voterlist->general_election;
        return view('poling_stationwise_voterlists.wardwise_documents',compact(['nomination_docs','wardwise_documents','currentLocale','poling_stationwise_voterlist','general_election']));
    }	
	
	public function polingStationwiseVoterlistDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$wardwise_doc->poling_stationwise_voterlist->general_election->nomination_docs;
		$general_election=$wardwise_doc->poling_stationwise_voterlist->general_election;
        return view('poling_stationwise_voterlists.wardwise_document_view',compact(['nomination_docs','wardwise_doc','currentLocale','general_election']));
    }	

// final voter list
	
	public function finalVoterlist(GeneralElection $general_election)
    {
		//echo "<pre>";print_r($general_election);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
        return view('final_voterlists',compact(['general_election','currentLocale','nomination_docs']));
    }	
	
	public function finalVoterlistDocs(FinalVoterlist $final_voterlist)
    {
		$wardwise_documents=$final_voterlist->wardwise_docs;
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$final_voterlist->general_election->nomination_docs;
		$general_election=$final_voterlist->general_election;
        return view('final_voterlists.wardwise_documents',compact(['wardwise_documents','currentLocale','final_voterlist','nomination_docs','general_election']));
    }	
	
	public function finalVoterlistDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$wardwise_doc->final_voterlist->general_election->nomination_docs;
		$general_election=$wardwise_doc->final_voterlist->general_election;
        return view('final_voterlists.wardwise_document_view',compact(['wardwise_doc','currentLocale','nomination_docs','general_election']));
    }	
	
	// muncipal corporation
	
	public function muncipalCorporation(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
        return view('muncipal_corporations',compact(['general_election','currentLocale','nomination_docs']));
    }	
	
	public function muncipalCorporationDocs(MuncipalCorporation $muncipal_corporation)
    {
		$wardwise_documents=$muncipal_corporation->wardwise_docs;
		//echo "<pre>";print_r($muncipal_corporation);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$muncipal_corporation->general_election->nomination_docs;
		$general_election=$muncipal_corporation->general_election;
        return view('muncipal_corporations.wardwise_documents',compact(['wardwise_documents','currentLocale','muncipal_corporation','nomination_docs','general_election']));
    }	
	
	public function muncipalCorporationDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		
		$currentLocale = App::getLocale();
		$nomination_docs=$wardwise_doc->muncipal_corporation->general_election->nomination_docs;
		$general_election=$wardwise_doc->muncipal_corporation->general_election;
		
		//echo "<pre>";print_r($general_election);echo "</pre>";die();
        return view('muncipal_corporations.wardwise_document_view',compact(['wardwise_doc','currentLocale','nomination_docs','general_election']));
    }	
	
	// Nomination Docs
	
	public function nominationWards(NominationDocs $nomination_doc)
    {
		$currentLocale = App::getLocale();
		$nomination_wards=$nomination_doc->nomination_wards;
		$general_election=$nomination_doc->general_election;
		$nomination_docs=$general_election->nomination_docs;
		//echo "<pre>";print_r($nomination_docs);echo "</pre>";die();	
        return view('nomination_wards',compact(['general_election','currentLocale','nomination_wards','nomination_doc','nomination_docs']));
    }	
	
	public function nominationWardDocs(NominationWard $nomination_ward)
    {
		$wardwise_documents=$nomination_ward->wardwise_docs;
		$nomination_doc=$nomination_ward->nomination_doc;
		$general_election=$nomination_doc->general_election;
		$nomination_docs=$general_election->nomination_docs;
		//echo "<pre>";print_r($nomination_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
        return view('nomination_wards.wardwise_documents',compact(['general_election','nomination_docs','wardwise_documents','currentLocale','nomination_doc','nomination_ward']));
    }	
	
	public function nominationWardDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$nomination_ward=$wardwise_doc->nomination_ward;
		$nomination_doc=$nomination_ward->nomination_doc;
		$general_election=$nomination_doc->general_election;
		$nomination_docs=$general_election->nomination_docs;
		$nomination_wards=$nomination_doc->nomination_wards;
		$currentLocale = App::getLocale();
        return view('nomination_wards.wardwise_document_view',compact(['wardwise_doc','currentLocale','nomination_docs','nomination_wards','general_election','nomination_doc']));
    }	
		
	// muncipal corporation
	
	public function wardwiseElectionResult(GeneralElection $general_election)
    {
		
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
        return view('wardwise_election_results',compact(['general_election','currentLocale','nomination_docs']));
    }	
	
	public function wardwiseElectionResultDocs(WardwiseElectionResult $wardwise_election_result)
    {
		$wardwise_documents=$wardwise_election_result->wardwise_docs;
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$wardwise_election_result->general_election->nomination_docs;
		$general_election=$wardwise_election_result->general_election;
        return view('wardwise_election_results.wardwise_documents',compact(['general_election','wardwise_documents','currentLocale','wardwise_election_result','nomination_docs']));
    }	
	
	public function wardwiseElectionResultDocView($id)
    {		
		$wardwise_doc=WardwiseDocs::find($id);
		//echo "<pre>";print_r($wardwise_doc);echo "</pre>";die();
		$currentLocale = App::getLocale();
		$nomination_docs=$wardwise_doc->wardwise_election_result->general_election->nomination_docs;
		$general_election=$wardwise_doc->wardwise_election_result->general_election;
        return view('wardwise_election_results.wardwise_document_view',compact(['wardwise_doc','currentLocale','nomination_docs','general_election']));
    }
		
	public function wardComposition(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
		$nomination_docs=$general_election->nomination_docs;
		$ward_compositions=$general_election->ward_compositions;
        return view('ward_composition',compact(['currentLocale','nomination_docs','general_election','ward_compositions']));
    }
	
	public function downloadFile($filename)
	{
		$filePath = storage_path('app/public/' . $filename);

		if (!file_exists($filePath)) {
			abort(404, 'Image not found.');
		}

		return response()->download($filePath);
	}
}
