<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePolingStationwiseVoterlistRequest;
use App\Http\Requests\UpdatePolingStationwiseVoterlistRequest;
use App\Models\PolingStationwiseVoterlist;
use App\Models\GeneralElection;
use App\Models\WardwiseDocs;
use Illuminate\Http\Request;
use App;

class PolingStationwiseVoterlistController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $poling_stationwise_voterlists = $general_election->poling_stationwise_voterlists;//PolingStationwiseVoterlist::all();
        return view('poling_stationwise_voterlists.index', compact(['poling_stationwise_voterlists','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('poling_stationwise_voterlists.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePolingStationwiseVoterlistRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$poling_stationwise_voterlist=PolingStationwiseVoterlist::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'general_election_id' =>$general_election->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'poling_stationwise_voterlist_id' => $poling_stationwise_voterlist->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
		
		
		
        return redirect()->route('poling_stationwise_voterlists.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        return view('poling_stationwise_voterlists.edit', compact('poling_stationwise_voterlist'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
		//echo "<pre>";print_r($poling_stationwise_voterlist);echo "</pre>";die();
        return view('poling_stationwise_voterlists.edit', compact('poling_stationwise_voterlist'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatePolingStationwiseVoterlistRequest $request, PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'poling_stationwise_voterlist_id' => $poling_stationwise_voterlist->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
				
        $poling_stationwise_voterlist->update($data);
		
        return redirect()->route('poling_stationwise_voterlists.index',$poling_stationwise_voterlist->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PolingStationwiseVoterlist $poling_stationwise_voterlist)
    {
        $poling_stationwise_voterlist->delete();
        return redirect()->route('poling_stationwise_voterlists.index',$poling_stationwise_voterlist->general_election);
    }
}
