<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreNominationDocsRequest;
use App\Http\Requests\UpdateNominationDocsRequest;
use App\Models\NominationDocs;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;
use Auth;

class NominationDocsController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $nomination_docs = $general_election->nomination_docs;//NominationDocs::all();
		
		//echo "<pre>";print_r($nomination_docs);echo "</pre>";die();
		
        return view('nomination_docs.index', compact(['nomination_docs','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('nomination_docs.create',compact('general_election','currentLocale'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNominationDocsRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
	
		$nomination_doc=NominationDocs::create([
			'returning_officer_en' => $data['returning_officer_en'],
			'returning_officer_mr' => $data['returning_officer_mr'],			
			'general_election_id' =>$general_election->id
		]);			
		
        return redirect()->route('nomination_docs.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(NominationDocs $NominationDocs)
    {
        return view('nomination_docs.edit', compact('nomination_doc'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NominationDocs $nomination_doc)
    {
        return view('nomination_docs.edit', compact('nomination_doc'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateNominationDocsRequest $request, NominationDocs $nomination_doc)
    {
        $data = $request->validated();		 
		
        $nomination_doc->update($data);
		
        return redirect()->route('nomination_docs.index',$nomination_doc->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NominationDocs $nomination_doc)
    {
        $nomination_doc->delete();
        return redirect()->route('nomination_docs.index',$nomination_doc->general_election);
    }
}
