<?php

namespace App\Http\Controllers;

use App\Models\MuncipalCorporation;
use App\Models\GeneralElection;
use App\Models\WardwiseDocs;
use Illuminate\Http\Request;
use App\Http\Requests\StoreMuncipalCorporationRequest;
use App\Http\Requests\UpdateMuncipalCorporationRequest;
use App;
use Auth;

class MuncipalCorporationController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $muncipal_corporations =$general_election->muncipal_corporations;// MuncipalCorporation::all();
        return view('muncipal_corporations.index', compact(['muncipal_corporations','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('muncipal_corporations.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMuncipalCorporationRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		
		$muncipal_corporation=MuncipalCorporation::create([
			'ward_en' => $data['ward_en'],
			'ward_mr' => $data['ward_mr'],			
			'general_election_id' =>$general_election->id
		]);	

		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'muncipal_corporation_id' => $muncipal_corporation->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}	
		
        return redirect()->route('muncipal_corporations.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(MuncipalCorporation $muncipal_corporation)
    {
        return view('muncipal_corporations.edit', compact('muncipal_corporation'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MuncipalCorporation $muncipal_corporation)
    {
		//echo "<pre>";print_r($muncipal_corporation);echo "</pre>";die();
        return view('muncipal_corporations.edit', compact('muncipal_corporation'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMuncipalCorporationRequest $request, MuncipalCorporation $muncipal_corporation)
    {
        $data = $request->validated();		 
				
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		if ($request->hasFile('files')) {
			foreach ($request->file('files') as $file) {
				$filename = time() . '_' . $file->getClientOriginalName();
				$path = $file->storeAs('uploads', $filename, 'public');
				$file_ext=pathinfo($path, PATHINFO_EXTENSION);
				WardwiseDocs::create([
					'muncipal_corporation_id' => $muncipal_corporation->id,
					'file_ext' => $file_ext,
					'filepath' => $path,
				]);
			}
		}		
		
        $muncipal_corporation->update($data);
		
        return redirect()->route('muncipal_corporations.index',$muncipal_corporation->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MuncipalCorporation $muncipal_corporation)
    {
        $muncipal_corporation->delete();
        return redirect()->route('muncipal_corporations.index',$muncipal_corporation->general_election);
    }
}
