@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
 
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
			<nav aria-label="breadcrumb">
			  <ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{route('general_elections.index')}}">General Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nagpur_muncipalelections.show',$general_election)}}">Nagpur Muncipal Elections</a></li>
				<li class="breadcrumb-item active" aria-current="page">Ward-wise election results</li>
			  </ol>
			</nav>
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('List of Ward-wise election results') }} of {{$general_election->title_en}}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('wardwise_election_results.create',$general_election) }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Ward</th>
					<th class="text-center">File</th>
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
						@foreach ($wardwise_election_results as $wardwise_election_result)
						<tr>
							<td style="text-align:left">
								<a href="#">
									@if($currentLocale=='en')
										{{ $wardwise_election_result->ward_en }}
									@else
										{{ $wardwise_election_result->ward_mr }}	
									@endif
								</a>
							</td>
							<td class="text-center">
								@if($currentLocale=='en')
									@if($wardwise_election_result->file_ext_en == 'pdf')
										<img src="{{ asset('build/assets/images/pdf.png') }}" alt="File" style="width:40px;height:40px">
									@else
										<img src="{{ asset('build/assets/images/image.png') }}" alt="File" style="width:40px;height:40px">
									@endif
								@else
									@if($wardwise_election_result->file_ext_mr == 'pdf')
										<img src="{{ asset('build/assets/images/pdf.png') }}" alt="File" style="width:40px;height:40px">
									@else
										<img src="{{ asset('build/assets/images/image.png') }}" alt="File" style="width:40px;height:40px">
									@endif
								@endif
							</td>
							<td><a href="{{ route('wardwise_election_results.edit',$wardwise_election_result) }}"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="{{ route('wardwise_election_results.destroy', $wardwise_election_result) }}" method="POST" style="display:inline;">
								@csrf
								<!-- @method('DELETE') -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						@endforeach
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection