@extends('layouts.app')
@section('content')
<style>
    table {
      width: 100%;
      height: 50px; /* set a height so vertical centering is visible */
      border-collapse: collapse;
    }
    td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #ccc;
    }
  </style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
		 <nav aria-label="breadcrumb">
			  <ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{route('general_elections.index')}}">General Elections</a></li>
				<li class="breadcrumb-item"><a href="{{route('nagpur_muncipalelections.show',$general_election)}}">Nagpur Muncipal Elections</a></li>
				<li class="breadcrumb-item active" aria-current="page">Namination Documents</li>
			  </ol>
			</nav>
            <div class="card">
                <div class="card-header">
					<div class="d-flex justify-content-between align-items-center">
						<div>
							{{ __('Nomination Docs') }}
						</div>
						<div>
							<a style="text-decoration:none;" href="{{ route('nomination_docs.create',$general_election) }}">Add</a>
						</div>
					</div>
				</div>

                <div class="card-body">
					<input class="pull-right mb-3" type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name">
                    <table class="table table-bordered table-striped">
					<thead class="table-light">
					<th>Returning Officer</th>
					<!-- <th class="text-center">File</th> -->
					<th class="text-center">Action</th>
					</thead>
					<tbody id="myTable">
						@foreach ($nomination_docs as $nomination_doc)
						<tr>
							<td style="text-align:left">
								<a href="{{ route('nomination_docs.index', $nomination_doc) }}">
									@if($currentLocale=='en')
										{{ $nomination_doc->returning_officer_en }}
									@else
										{{ $nomination_doc->returning_officer_mr }}	
									@endif
								</a>
							</td>
							
							<!-- <td class="text-center">
								@if($currentLocale=='en')
									<img src="{{ asset('storage/' . $nomination_doc->file_en) }}" alt="File" style="width:40px;height:40px">
								@else
									<img src="{{ asset('storage/' . $nomination_doc->file_mr) }}" alt="File" style="width:40px;height:40px">
								@endif
							</td> -->
							<td><a href="{{ route('nomination_docs.edit', $nomination_doc) }}"><i class="fa-regular fa-edit"></i></a> 
							
							<form action="{{ route('nomination_docs.destroy', $nomination_doc) }}" method="POST" style="display:inline;">
								@csrf
								<!-- @method('DELETE') -->
								<button style="border:none" type="submit" ><i class="fa fa-trash-o text-danger"></i></button>
							</form>
							</td>
						</tr>
						@endforeach
					</tbody>
					</table>
					
                </div>
            </div>
        </div>
    </div>
</div>
<script>
function myFunction() {
  var input, filter, table, tr, td, i, txtValue;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  table = document.getElementById("myTable");
  tr = table.getElementsByTagName("tr");
  for (i = 0; i < tr.length; i++) {
    td = tr[i].getElementsByTagName("td")[0];
    if (td) {
      txtValue = td.textContent || td.innerText;
      if (txtValue.toUpperCase().indexOf(filter) > -1) {
        tr[i].style.display = "";
      } else {
        tr[i].style.display = "none";
      }
    }       
  }
}
</script>
@endsection